<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>My PWA</title>
  <link rel="manifest" href="/manifest.json">
</head>
<body>
  <!-- Your content here -->

  <!-- Install PWA Button -->
  <button id="install-button" style="display: none;">Install App</button>
  <div id="offline-message" style="display: none; color: red;">You are offline. Please check your internet connection.</div>

  <script>
    // Register the service worker
    if ('serviceWorker' in navigator) {
      window.addEventListener('load', () => {
        navigator.serviceWorker.register('/service-worker.js').then(registration => {
          console.log('Service Worker registered with scope:', registration.scope);
        }).catch(error => {
          console.log('Service Worker registration failed:', error);
        });
      });
    }

    let deferredPrompt;
    const installButton = document.getElementById('install-button');
    const offlineMessage = document.getElementById('offline-message');

    window.addEventListener('beforeinstallprompt', (e) => {
      e.preventDefault();
      deferredPrompt = e;
      installButton.style.display = 'block';

      installButton.addEventListener('click', () => {
        installButton.style.display = 'none';
        deferredPrompt.prompt();
        deferredPrompt.userChoice.then((choiceResult) => {
          if (choiceResult.outcome === 'accepted') {
            console.log('User accepted the A2HS prompt');
          } else {
            console.log('User dismissed the A2HS prompt');
          }
          deferredPrompt = null;
        });
      });
    });

    window.addEventListener('online', () => {
      offlineMessage.style.display = 'none';
    });

    window.addEventListener('offline', () => {
      offlineMessage.style.display = 'block';
    });
  </script>
</body>
</html> 
