<?php
include("config.php");

// Check if club_id is provided
if (isset($_GET['club_id'])) {
    $club_id = intval($_GET['club_id']);

    // Fetch club details including history
    $result = $conn->query("SELECT clubs.*, leagues.name AS league_name 
                            FROM clubs 
                            LEFT JOIN leagues ON clubs.league_id = leagues.id 
                            WHERE clubs.id = $club_id");

    // If the club is found, display club details and history
    if ($result->num_rows > 0) {
        $club = $result->fetch_assoc();
        ?>

        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Club History</title>
            <style>
                .button-group {
                    margin-top: 20px;
                }
                .button-group a {
                    display: inline-block;
                    margin: 5px;
                    padding: 10px 15px;
                    text-decoration: none;
                    background-color: #007bff;
                    color: white;
                    border-radius: 5px;
                    font-size: 14px;
                }
                .button-group a:hover {
                    background-color: #0056b3;
                }
            </style>
        </head>
        <body>
            <h2>Club History for <?= htmlspecialchars($club['club_name']) ?></h2>

            <!-- Display Club Details -->
            <p><strong>Club Name:</strong> <?= htmlspecialchars($club['club_name']) ?></p>
            <p><strong>League:</strong> <?= htmlspecialchars($club['league_name']) ?></p>
            <p><strong>Description:</strong> <?= htmlspecialchars($club['description'] ?? 'N/A') ?></p>

            <!-- Display the current history or provide an empty form if no history exists -->
            <form action="club_history.php?club_id=<?= $club_id ?>" method="POST">
                <label for="history">Club History:</label><br>
                <textarea name="history" id="history" rows="5" cols="50" required><?= htmlspecialchars($club['history'] ?? '') ?></textarea><br><br>
                <button type="submit">Update History</button>
            </form>

            <?php
            // Handle form submission to update club history
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $history = $_POST['history'];

                // Update the club history in the clubs table
                $updateQuery = $conn->prepare("UPDATE clubs SET history = ? WHERE id = ?");
                $updateQuery->bind_param("si", $history, $club_id);

                if ($updateQuery->execute()) {
                    echo "<p style='color: green;'>Club history updated successfully!</p>";
                } else {
                    echo "<p style='color: red;'>Error: " . $updateQuery->error . "</p>";
                }

                $updateQuery->close();
            }
            ?>

            <!-- Button to go back -->
            <div class="button-group">
                <a href="view_club_detail.php?club_id=<?= $club_id ?>">Back to Club Details</a>
            </div>
        </body>
        </html>

        <?php
    } else {
        echo "Club not found.";
    }
} else {
    echo "Invalid club ID.";
}
?>
