<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">  
  <style>
    body {
      background-color: #fff;
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      margin: 0;
    }

    .login-container {
      width: 100%;
      max-width: 600px;
      height: 100vh;
      padding: 20px;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      text-align: center;
      border-radius: 10px;
      background-color: #000;
      border: 5px solid black;
      color: white;
    }

    .logo img {
      width: 100%;
      max-width: 250px;
      margin: 0 auto;
    }

    .login-form {
      margin-top: auto;
      display: flex;
      flex-direction: column;
      gap: 20px;
    }

    .grid-menu {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 20px;
      margin-bottom: 20px;
    }

    .grid-item {
      background-color: #ffffff;
      color: #000;
      border: none;
      border-radius: 10px;
      padding: 10px;
      font-size: 14px;
      text-align: center;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      transition: transform 0.2s, box-shadow 0.2s;
    }

    .grid-item img {
      width: 70px;
      height: 50px;
      margin-bottom: 10px;
    }

    .grid-item:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
    }

    .login-button {
      width: 25%;
      padding: 15px;
      background-color: white;
      color: black;
      font-size: 18px;
      font-weight: bold;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }
  </style>
  <title>Sharhin Wasanni Login</title>
</head>
<body>
  <div class="login-container">
    <div class="logo">
      <img src="../sharhinwasannilogo.png" alt="Sharhin Wasanni Logo">
    </div>
    <div class="login-form">
      <div class="grid-menu">
        <?php
        // Database connection (modify as needed)
        include("config.php");

        // Fetch all countries from the database
        $result = $conn->query("SELECT id, name, flag FROM countries ORDER BY name ASC");

        if ($result->num_rows > 0):
          while ($row = $result->fetch_assoc()): ?>
            <div class="grid-item">
              <?php if (!empty($row['flag'])): ?>
                <img src="../<?php echo htmlspecialchars($row['flag']); ?>" alt="Flag of <?php echo htmlspecialchars($row['name']); ?>">
              <?php else: ?>
                <img src="https://via.placeholder.com/70x50?text=No+Flag" alt="No flag available">
              <?php endif; ?>
              <span><?php echo htmlspecialchars($row['name']); ?></span>
            </div>
          <?php endwhile;
        else: ?>
          <p>No countries found.</p>
        <?php endif;

        $conn->close();
        ?>
      </div>
      <button onclick="window.location.href='dashboard.php';" class="login-button">Back</button>
    </div>
  </div>
</body>
</html>
