<?php
include("config.php");

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // Fetch the footballer record to get the image path
    $result = $conn->query("SELECT * FROM footballers WHERE id = $id");
    $footballer = $result->fetch_assoc();

    if (!$footballer) {
        echo "Footballer not found.";
        exit;
    }

    // Delete the image file if it exists
    if (!empty($footballer['image']) && file_exists("../footballers/" . $footballer['image'])) {
        unlink("../footballers/" . $footballer['image']);
    }

    // Delete the footballer record from the database
    $stmt = $conn->prepare("DELETE FROM footballers WHERE id = ?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        header("Location: footballers.php?club_id=" . $footballer['club_id']);
        exit;
    } else {
        echo "Error deleting record: " . $stmt->error;
    }
} else {
    echo "Invalid request.";
    exit;
}
?>
