<?php
// login.php

// Include the database connection
require 'config.php';

session_start();

$error = ''; // Initialize an empty error message

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Prepare the SQL statement
    $query = "SELECT * FROM admins WHERE username = ?";
    
    if ($stmt = mysqli_prepare($conn, $query)) {
        // Bind parameters
        mysqli_stmt_bind_param($stmt, "s", $username);
        
        // Execute the statement
        mysqli_stmt_execute($stmt);
        
        // Get the result
        $result = mysqli_stmt_get_result($stmt);
        
        // Fetch the admin record
        $admin = mysqli_fetch_assoc($result);
        
        // Verify the password
        if ($admin && password_verify($password, $admin['password'])) {
            // Password is correct, create session
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_username'] = $admin['username'];
            header('Location: dashboard.php');
            exit;
        } else {
            $error = "Invalid username or password."; // Set the error message
        }

        // Close the statement
        mysqli_stmt_close($stmt);
    } else {
        $error = "Error: Unable to prepare the SQL statement.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
   body {
       
  background-color: #fff;
  
  height: 100vh;
  display: flex;
  justify-content: center;
  align-items: center;
  margin: 0;
}

.login-container {
  width: 100%;
  max-width: 400px;
  height: 100vh;              /* Full viewport height */
  padding: 20px;
  display: flex;
  flex-direction: column;
  justify-content: space-between; /* Space out elements to push the form down */
  text-align: center;
  border-radius: 10px;
  background-color: #000;
  border: 5px solid black;
}

.logo img {
  width: 100%;
  max-width: 250px;
  margin: 0 auto;            /* Center the logo horizontally */
}

.login-form {
  margin-top: auto;          /* Push the form to the bottom */
  display: flex;
  flex-direction: column;
  gap: 20px;                 /* Add spacing between form elements */
}

.login-form input {
  width: 100%;
  padding: 15px;
  border: none;
  border-bottom: 2px solid white;
  background: transparent;
  color: white;
  font-size: 16px;
  outline: none;
}

.login-form input::placeholder {
  color: white;
}

.login-button {
  width: 100%;
  padding: 15px;
  background-color: white;
  color: black;
  font-size: 18px;
  font-weight: bold;
  border: none;
  border-radius: 5px;
  cursor: pointer;
}
    .error-message {
      color: red;
      font-size: 16px;
      text-align: center;
    }
  </style>
  <title>Sharhin Wasanni Login</title>
</head>
<body>
  <div class="login-container">
    <br><br>
    <div class="logo">
      <img src="../sharhinwasannilogo.png" alt="Sharhin Wasanni Logo">
    </div>
    <form method="POST" action="" class="login-form">
      <input type="text" name="username" placeholder="Username" class="username-input" required>
      <input type="password" name="password" placeholder="Password" class="password-input" required>
      <?php if ($error): ?>
        <div class="error-message"><?= htmlspecialchars($error); ?></div>
      <?php endif; ?>
      <button type="submit" class="login-button">Login</button>
    </form>
  </div>
</body>
</html>
