<?php
include("config.php");

// Fetch countries, leagues, and clubs for the form
$countries = $conn->query("SELECT id, name FROM countries ORDER BY name ASC");
$clubs = $conn->query("SELECT clubs.id, clubs.club_name, leagues.name AS league_name, countries.name AS country_name
                       FROM clubs
                       JOIN leagues ON clubs.league_id = leagues.id
                       JOIN countries ON leagues.country_id = countries.id
                       ORDER BY country_name, league_name, club_name ASC");

// Handle match scheduling
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_match'])) {
    $country_id = $_POST['country_id'];
    $club1_id = $_POST['club1_id'];
    $club2_id = $_POST['club2_id'];
    $match_date = $_POST['match_date'];
    $match_time = $_POST['match_time'];
    $match_link = $_POST['match_link'] ?: null;

    // Ensure Club 1 and Club 2 are not the same
    if ($club1_id === $club2_id) {
        echo "<p style='color:red;'>Error: Club 1 and Club 2 cannot be the same.</p>";
    } else {
        $stmt = $conn->prepare("INSERT INTO matches (country_id, club1_id, club2_id, match_date, match_time, match_link) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iiisss", $country_id, $club1_id, $club2_id, $match_date, $match_time, $match_link);

        if ($stmt->execute()) {
            echo "<p style='color:green;'>Match scheduled successfully!</p>";
        } else {
            echo "<p style='color:red;'>Error scheduling match: " . $conn->error . "</p>";
        }
    }
}

// Fetch scheduled matches for display
$matches = $conn->query("SELECT 
                            matches.id, matches.match_date, matches.match_time, matches.match_link,
                            c1.club_name AS club1_name, c2.club_name AS club2_name,
                            leagues.name AS league_name, countries.name AS country_name
                         FROM matches
                         JOIN clubs c1 ON matches.club1_id = c1.id
                         JOIN clubs c2 ON matches.club2_id = c2.id
                         JOIN leagues ON c1.league_id = leagues.id
                         JOIN countries ON leagues.country_id = countries.id
                         ORDER BY matches.match_date, matches.match_time ASC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Match Scheduling</title>
</head>
<body>
    <h1>Schedule a Match</h1>
    <form method="POST">
        <label for="country_id">Select Country:</label>
        <select name="country_id" id="country_id" required>
            <option value="">Choose Country</option>
            <?php while ($country = $countries->fetch_assoc()): ?>
                <option value="<?= $country['id'] ?>"><?= $country['name'] ?></option>
            <?php endwhile; ?>
        </select>

        <label for="club1_id">Select Club 1:</label>
        <select name="club1_id" id="club1_id" required>
            <option value="">Choose Club 1</option>
            <?php while ($club = $clubs->fetch_assoc()): ?>
                <option value="<?= $club['id'] ?>"><?= $club['club_name'] ?> (<?= $club['country_name'] ?> - <?= $club['league_name'] ?>)</option>
            <?php endwhile; ?>
        </select>

        <label for="club2_id">Select Club 2:</label>
        <select name="club2_id" id="club2_id" required>
            <option value="">Choose Club 2</option>
            <?php
            $clubs->data_seek(0); // Reset pointer for re-use
            while ($club = $clubs->fetch_assoc()): ?>
                <option value="<?= $club['id'] ?>"><?= $club['club_name'] ?> (<?= $club['country_name'] ?> - <?= $club['league_name'] ?>)</option>
            <?php endwhile; ?>
        </select>

        <label for="match_date">Match Date:</label>
        <input type="date" name="match_date" id="match_date" required>

        <label for="match_time">Match Time:</label>
        <input type="time" name="match_time" id="match_time" required>

        <label for="match_link">Watch Match Link (Optional):</label>
        <input type="url" name="match_link" id="match_link" placeholder="https://example.com" pattern="https?://.*">

        <button type="submit" name="add_match">Schedule Match</button>
    </form>

    <h1>Scheduled Matches</h1>
    <?php while ($match = $matches->fetch_assoc()): ?>
        <div>
            <h3><?= $match['club1_name'] ?> vs <?= $match['club2_name'] ?></h3>
            <p><strong>Date:</strong> <?= $match['match_date'] ?> | <strong>Time:</strong> <?= $match['match_time'] ?></p>
            <p><strong>League:</strong> <?= $match['league_name'] ?> (<?= $match['country_name'] ?>)</p>
            <?php if ($match['match_link']): ?>
                <a href="<?= $match['match_link'] ?>" target="_blank">Watch Match</a>
            <?php else: ?>
                <p>No link available</p>
            <?php endif; ?>
        </div>
    <?php endwhile; ?>
</body>
</html>
