<?php
include("config.php");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Management</title>
    <style>
        a {
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <h2>Data Management</h2>

    <table border="1" width="100%">
        <thead>
            <tr>
                <th>Type</th>
                <th>Image/Flag</th>
                <th>Name</th>
                <th>Additional Info</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Fetch leagues
            $leagues = $conn->query("SELECT leagues.id, leagues.name, leagues.image, countries.name AS country_name 
                                    FROM leagues 
                                    JOIN countries ON leagues.country_id = countries.id 
                                    ORDER BY leagues.name ASC");
            while ($row = $leagues->fetch_assoc()) { ?>
                <tr>
                    <td>League</td>
                    <td><img src="../<?= $row['image'] ?>" alt="League Image" width="50" height="50"></td>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td>Country: <?= htmlspecialchars($row['country_name']) ?></td>
                    <td>
                        <a href="?delete=true&type=league&id=<?= $row['idsssss'] ?>" onclick="return confirm('Are you sure you want to delete this league?');"></a>
                        <a href="add_league_cup_image.php?league_id=<?= $row['id'] ?>">Add/View League Cup Image</a>
                    </td>
                </tr>
            <?php }

            // Fetch clubs
            $clubs = $conn->query("SELECT clubs.id, clubs.club_name, clubs.image, leagues.name AS league_name 
                                    FROM clubs 
                                    JOIN leagues ON clubs.league_id = leagues.id 
                                    ORDER BY clubs.club_name ASC");
            while ($row = $clubs->fetch_assoc()) { ?>
                <tr>
                    <td>Club</td>
                    <td><img src="../<?= $row['image'] ?>" alt="Club Image" width="50" height="50"></td>
                    <td><?= htmlspecialchars($row['club_name']) ?></td>
                    <td>League: <?= htmlspecialchars($row['league_name']) ?></td>
                    <td>
                        <a href="?delete=true&type=club&id=<?= $row['idsss'] ?>" onclick="return confirm('Are you sure you want to delete this club?');"></a>
                        <a href="view_club_detail.php?club_id=<?= $row['id'] ?>">View Club Details</a>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</body>
</html>
