<?php
include("config.php");

// Handle search input
$searchTerm = isset($_GET['search']) ? $_GET['search'] : '';

// Fetch clubs with league and country information, filtered by search term
$clubs = $conn->prepare("
    SELECT clubs.id, clubs.club_name, clubs.image AS club_image, 
           leagues.name AS league_name, countries.name AS country_name
    FROM clubs
    JOIN leagues ON clubs.league_id = leagues.id
    JOIN countries ON leagues.country_id = countries.id
    WHERE clubs.club_name LIKE ?
    ORDER BY clubs.club_name ASC
");
$searchTermLike = "%$searchTerm%";
$clubs->bind_param("s", $searchTermLike);
$clubs->execute();
$result = $clubs->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #fff;
      margin: 0;
      font-family: Arial, sans-serif;
      padding: 20px;
    }

    .container {
      max-width: 600px;
      margin: 0 auto;
      background-color: #000;
      padding: 20px;
      border-radius: 10px;
      color: #fff;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    }

    .logo img {
      width: 100%;
      max-width: 250px;
      margin: 0 auto 20px;
      display: block;
    }

.search-bar {
  width: 100%;
  max-width: 100%; /* Ensures it doesn’t exceed the container width */
  margin-bottom: 20px;
}

.search-input-container {
  position: relative;
  width: 100%; /* Makes the container take full width */
}

.search-input-container input[type="text"] {
  width: 100%; /* Makes the input field take full width */
  padding: 10px 40px 10px 15px; /* Space for the icon on the right */
  border: 1px solid #ccc;
  border-radius: 5px;
  font-size: 16px;
  box-sizing: border-box; /* Ensures padding doesn't increase input width */
}

.search-input-container button {
  position: absolute;
  right: 10px;
  top: 50%;
  transform: translateY(-50%);
  background: none;
  border: none;
  color: #555;
  cursor: pointer;
  font-size: 18px;
}

.search-input-container button:hover {
  color: #000;
}


    .grid-menu {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
      gap: 15px;
    }

    .grid-item {
      background-color: #fff;
      color: #000;
      border-radius: 10px;
      padding: 10px;
      text-align: center;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      transition: transform 0.2s, box-shadow 0.2s;
    }

    .grid-item img {
      width: 60px;
      height: 60px;
      object-fit: cover;
      margin-bottom: 10px;
      border-radius: 5px;
    }

    .grid-item h3 {
      font-size: 16px;
      margin: 5px 0;
    }

    .grid-item p {
      font-size: 14px;
      color: #555;
      margin: 2px 0;
    }

    .grid-item:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
    }
  </style>
  <title>View Clubs</title>
</head>
<body>
  <div class="container">
    <div class="logo">
      <img src="../sharhinwasannilogo.png" alt="Sharhin Wasanni Logo">
    </div>

  <form class="search-bar" method="GET" action="">
  <div class="search-input-container">
    <input type="text" name="search" placeholder="Search club by name..." value="<?= htmlspecialchars($searchTerm) ?>">
    <button type="submit"><i class="fas fa-search"></i></button>
  </div>
</form>


    <div class="grid-menu">
      <?php while ($row = $result->fetch_assoc()): ?>
        <div class="grid-item">
          <a href="view_club_detail.php?club_id=<?= $row['id'] ?>">
            <img src="../<?= htmlspecialchars($row['club_image']) ?>" alt="Club Image">
          </a>
          <h3><?= htmlspecialchars($row['club_name']) ?></h3>
          <p><?= htmlspecialchars($row['country_name']) ?></p>
          <p><?= htmlspecialchars($row['league_name']) ?></p>
        </div> 
      <?php endwhile; ?>
    </div>
  </div>
</body>
</html>

<?php $conn->close(); ?>
