<?php
include("config.php");

if (isset($_GET['club_id'])) {
    $club_id = intval($_GET['club_id']);
    $result = $conn->query("SELECT clubs.*, leagues.name AS league_name 
                            FROM clubs 
                            JOIN leagues ON clubs.league_id = leagues.id 
                            WHERE clubs.id = $club_id");

    if ($result->num_rows > 0) {
        $club = $result->fetch_assoc();
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Club Details</title>
            <style>
                body {
                 background-color: #fff;
  
  height: 100vh;
  display: flex;
  justify-content: center;
 color: white;
  align-items: center;
  margin: 0;
                }

                .container {
                    width: 100%;
  max-width: 400px;
  height: 100vh;              /* Full viewport height */
  padding: 20px;
  display: flex;
  flex-direction: column;
  justify-content: space-between; /* Space out elements to push the form down */
  text-align: center;
  border-radius: 10px;
  background-color: #000;
  border: 5px solid black;
                }

                h2 {
                    text-align: center;
                }

                p {
                    font-size: 16px;
                    margin: 10px 0;
                }

                img {
                    display: block;
                    width: 100%;
                    max-width: 200px;
                    height: auto;
                    margin: 20px auto;
                    border-radius: 8px;
                }

                .button-group {
                    display: flex;
                    flex-wrap: wrap;
                    justify-content: center;
                    gap: 10px;
                    margin-top: 20px;
                }

                .button-group a {
                    display: inline-block;
                    padding: 10px 15px;
                    text-decoration: none;
                    background-color: #28a745;
                    color: white;
                    border-radius: 5px;
                    font-size: 14px;
                    text-align: center;
                    transition: background-color 0.2s;
                }

                .button-group a:hover {
                    background-color: #218838;
                }

                .back-link {
                    display: block;
                    text-align: center;
                    margin-top: 30px;
                    color: #007bff;
                    text-decoration: none;
                    font-size: 16px;
                }

                .back-link:hover {
                    text-decoration: underline;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <h2>Club Details</h2>
                <p><strong>Club Name:</strong> <?= htmlspecialchars($club['club_name']) ?></p>
                <p><strong>League:</strong> <?= htmlspecialchars($club['league_name']) ?></p>
                <p><strong>Description:</strong> <?= htmlspecialchars($club['description'] ?? 'N/A') ?></p>
                <img src="../<?= htmlspecialchars($club['image']) ?>" alt="Club Image">

                <!-- Button Group -->
                <div class="button-group">
                    <a href="club_history.php?club_id=<?= $club_id ?>">Club History</a>
                    <a href="footballers.php?club_id=<?= $club_id ?>">Footballers</a>
                    <a href="tournament.php?club_id=<?= $club_id ?>">Tournament</a>
                    <a href="coach.php?club_id=<?= $club_id ?>">Coach</a>
                    <a href="management.php?club_id=<?= $club_id ?>">Management</a>
                </div>

                <a class="back-link" href="index.php">Back to Data Management</a>
            </div>
        </body>
        </html>
        <?php
    } else {
        echo "<p>Club not found.</p>";
    }
} else {
    echo "<p>Invalid club ID.</p>";
}
?>

