<?php
include("config.php");

// Fetch leagues with their associated country names
$query = "SELECT leagues.id, leagues.name AS league_name, leagues.image, countries.name AS country_name
          FROM leagues
          JOIN countries ON leagues.country_id = countries.id
          ORDER BY leagues.name ASC";

$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">  
  <style>
   body {
       
  background-color: #fff;
  
  height: 100vh;
  display: flex;
  justify-content: center;
  align-items: center;
  margin: 0;
}

.login-container {
  width: 100%;
  max-width: 400px;
  height: 100vh;              /* Full viewport height */
  padding: 20px;
  display: flex;
  flex-direction: column;
  justify-content: space-between; /* Space out elements to push the form down */
  text-align: center;
  border-radius: 10px;
  background-color: #000;
  border: 5px solid black;
}

.logo img {
  width: 100%;
  max-width: 250px;
  margin: 0 auto;            /* Center the logo horizontally */
}

.login-form {
  margin-top: auto;          /* Push the form to the bottom */
  display: flex;
  flex-direction: column;
  gap: 20px;                 /* Add spacing between form elements */
}

.grid-menu {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 10px;
    margin-bottom: 20px;
}


    .grid-item {
      background-color: #ffffff;
      color: #000;
      border-radius: 10px;
      padding: 10px;
      font-size: 14px;
      text-align: center;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      transition: transform 0.2s, box-shadow 0.2s;
    }

    .grid-item img {
      width: 50px;
      height: 50px;
      object-fit: cover;
      margin-bottom: 10px;
      border-radius: 5px;
    }

    .grid-item:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
    }

    h1 {
      margin-bottom: 20px;
    }

    .message {
      margin-bottom: 20px;
      color: red;
    }
    .login-form {
  margin-top: auto;          /* Push the form to the bottom */
  display: flex;
  flex-direction: column;
  gap: 20px;                 /* Add spacing between form elements */
}
  </style>
  <title>View Leagues</title>
</head>
<body>
  <div class="login-container">
    <br><br>
    <div class="logo">
      <img src="../sharhinwasannilogo.png" alt="Sharhin Wasanni Logo">
    </div>
    <div class="login-form">
      <div class="grid-menu">
          
      <?php if ($result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
          <div class="grid-item">
            <?php if (!empty($row['image'])): ?>
              <img src="../<?php echo htmlspecialchars($row['image']); ?>" alt="League Image">
            <?php else: ?>
              <img src="https://via.placeholder.com/100?text=No+Image" alt="No Image Available">
            <?php endif; ?>
            <strong><?php echo htmlspecialchars($row['league_name']); ?></strong>
            <small><?php echo htmlspecialchars($row['country_name']); ?></small>
          </div>
        <?php endwhile; ?>
      <?php else: ?>
        <p class="message">No leagues found.</p>
      <?php endif; ?>

      <?php $conn->close(); ?>
    </div>
        </div> 
  </div>
</body>
</html>
