<?php
// db_connection.php should already include your database connection setup
require 'db_connection.php';

// Handle POST requests for create, edit, and delete operations
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];
        
        if ($action === 'create') {
            $category_name = $_POST['category_name'];
            $query = "INSERT INTO categories (category_name) VALUES ('$category_name')";
            if (mysqli_query($conn, $query)) {
                echo "Category created successfully.";
            } else {
                echo "Error: " . mysqli_error($conn);
            }
        } elseif ($action === 'edit') {
            $category_id = $_POST['category_id'];
            $category_name = $_POST['category_name'];
            $query = "UPDATE categories SET category_name = '$category_name' WHERE id = $category_id";
            if (mysqli_query($conn, $query)) {
                echo "Category updated successfully.";
            } else {
                echo "Error: " . mysqli_error($conn);
            }
        } elseif ($action === 'delete') {
            $category_id = $_POST['category_id'];
            $query = "DELETE FROM categories WHERE id = $category_id";
            if (mysqli_query($conn, $query)) {
                echo "Category deleted successfully.";
            } else {
                echo "Error: " . mysqli_error($conn);
            }
        }
    }
}

// Fetch categories for display
$categories = [];
$query = "SELECT * FROM categories ORDER BY id DESC";
$result = mysqli_query($conn, $query);
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $categories[] = $row;
    }
} else {
    echo "Error: " . mysqli_error($conn);
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Manage Categories</title>
</head>
<body>
    <h1>Manage Categories</h1>

    <!-- Create Category Form -->
    <h2>Create Category</h2>
    <form method="POST" action="">
        <input type="hidden" name="action" value="create">
        <input type="text" name="category_name" placeholder="Category Name" required><br>
        <button type="submit">Create Category</button>
    </form>

    <!-- Display Categories -->
    <h2>Categories List</h2>
    <table border="1">
        <thead>
            <tr>
                <th>ID</th>
                <th>Category Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($categories as $category): ?>
                <tr>
                    <td><?= htmlspecialchars($category['id']) ?></td>
                    <td><?= htmlspecialchars($category['category_name']) ?></td>
                    <td>
                        <!-- Edit Form -->
                        <form method="POST" action="" style="display:inline;">
                            <input type="hidden" name="action" value="edit">
                            <input type="hidden" name="category_id" value="<?= $category['id'] ?>">
                            <input type="text" name="category_name" value="<?= htmlspecialchars($category['category_name']) ?>" required>
                            <button type="submit">Edit</button>
                        </form>

                        <!-- Delete Form -->
                        <form method="POST" action="" style="display:inline;">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="category_id" value="<?= $category['id'] ?>">
                            <button type="submit" onclick="return confirm('Are you sure you want to delete this category?');">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table> 
</body>
</html>
