<?php
session_start();

require 'db_connection.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize input
    $phone = isset($_POST["phone"]) ? mysqli_real_escape_string($conn, $_POST["phone"]) : '';

    // Get admin ID from the session
    $admin_id = $_SESSION['admin_id'];

    // Check if phone number already exists in 'verify' table
    $sql_check_verify = "SELECT * FROM verify WHERE phone = ?";
    $stmt = $conn->prepare($sql_check_verify);
    $stmt->bind_param('s', $phone);
    $stmt->execute();
    $result_check_verify = $stmt->get_result();

    if ($result_check_verify->num_rows > 0) {
        // Phone number already exists in 'verify' table
        echo "<p>Phone number '$phone' already exists in the database.</p>";
    } else {
        // Insert the phone number into the 'verify' table without admin_id
        $sql_insert = "INSERT INTO verify (phone, status) VALUES (?, 0)";
        $stmt_insert = $conn->prepare($sql_insert);
        $stmt_insert->bind_param('s', $phone);

        if ($stmt_insert->execute()) {
            echo "<p>Phone number '$phone' registered successfully in the database.</p>";
        } else {
            echo "Error inserting phone number: " . $stmt_insert->error;
        }

        $stmt_insert->close();
    }

    $stmt->close();
}

// Close the database connection
$conn->close();
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Phone Number Registration</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 500px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h2 {
            text-align: center;
            color: #333;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #555;
        }

        input[type="text"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        input[type="submit"] {
            width: 100%;
            padding: 10px;
            background-color: #28a745;
            border: none;
            border-radius: 4px;
            color: white;
            font-size: 16px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #218838;
        }

        .message {
            text-align: center;
            font-size: 14px;
            color: red;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Register Phone Number</h2>
        <form action="add.php" method="POST">
            <label for="phone">Enter Phone Number:</label>
            <input type="text" id="phone" name="phone" required placeholder="Phone Number">
            <input type="submit" value="Register">
        </form>

        <!-- Message placeholder -->
        <div class="message">
            <!-- You can use PHP here to display any error or success messages -->
            <?php
            if (isset($message)) {
                echo $message;
            }
            ?>
        </div>
    </div>
</body>
</html>
