<?php
session_start();

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// Include the database connection
require 'db_connection.php';

// Handle Add Category
if (isset($_POST['add_category'])) {
    $name = htmlspecialchars($_POST['name']);
    $stmt = $conn->prepare("INSERT INTO cateories (name) VALUES (?)");
    $stmt->bind_param('s', $name);
    if ($stmt->execute()) {
        $message = "Category added successfully!";
    } else {
        $message = "Error: " . $stmt->error;
    }
}

// Handle Edit Category
if (isset($_POST['edit_category'])) {
    $id = intval($_POST['id']);
    $name = htmlspecialchars($_POST['name']);
    $stmt = $conn->prepare("UPDATE cateories SET name = ? WHERE id = ?");
    $stmt->bind_param('si', $name, $id);
    if ($stmt->execute()) {
        $message = "Category updated successfully!";
    } else {
        $message = "Error: " . $stmt->error;
    }
}

// Handle Delete Category
if (isset($_POST['delete_category'])) {
    $id = intval($_POST['id']);
    $stmt = $conn->prepare("DELETE FROM cateories WHERE id = ?");
    $stmt->bind_param('i', $id);
    if ($stmt->execute()) {
        $message = "Category deleted successfully!";
    } else {
        $message = "Error: " . $stmt->error;
    }
}

// Fetch all cateories
$categories = [];
$result = $conn->query("SELECT * FROM cateories ORDER BY created_at DESC");
if ($result) {
    $categories = $result->fetch_all(MYSQLI_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Categories</title>
    <style>/* General Styles */
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
    line-height: 1.6;
    background-color: #f4f4f9;
    color: #333;
}

h1, h2 {
    color: #444;
    text-align: center;
}

p {
    text-align: center;
    color: green;
    font-weight: bold;
}

/* Container */
form, table {
    margin: 20px auto;
    padding: 20px;
    width: 90%;
    max-width: 600px;
    background-color: #fff;
    border: 1px solid #ccc;
    border-radius: 8px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

/* Form Styles */
form h2 {
    font-size: 20px;
    margin-bottom: 15px;
    color: #555;
}

label {
    font-weight: bold;
    display: block;
    margin-bottom: 5px;
}

input[type="text"] {
    width: 100%;
    padding: 10px;
    margin-bottom: 15px;
    border: 1px solid #ccc;
    border-radius: 5px;
    font-size: 14px;
}

button {
    display: inline-block;
    padding: 10px 20px;
    background-color: #28a745;
    color: #fff;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 14px;
    transition: background-color 0.3s ease;
}

button:hover {
    background-color: #218838;
}

button:disabled {
    background-color: #ccc;
    cursor: not-allowed;
}

/* Table Styles */
table {
    width: 100%;
    border-collapse: collapse;
}

table th, table td {
    padding: 12px 15px;
    border: 1px solid #ddd;
    text-align: center;
}

table th {
    background-color: #007bff;
    color: white;
    font-weight: bold;
}

table tr:nth-child(even) {
    background-color: #f9f9f9;
}

table tr:hover {
    background-color: #f1f1f1;
}

table td form {
    display: inline-block;
    margin: 0 5px;
}

/* Responsive Design */
@media (max-width: 768px) {
    table, form {
        width: 100%;
    }

    input[type="text"], button {
        font-size: 16px;
    }

    table th, table td {
        padding: 10px;
        font-size: 14px;
    }
}
</style>
</head>
<body>
    <h1>Manage Categories</h1>

    <!-- Display message -->
    <?php if (!empty($message)): ?>
        <p><?= htmlspecialchars($message) ?></p>
    <?php endif; ?>

    <!-- Add Category Form -->
    <form method="post">
        <h2>Add Category</h2>
        <label for="name">Category Name:</label><br>
        <input type="text" id="name" name="name" required><br><br>
        <button type="submit" name="add_category">Add Category</button>
    </form>

    <hr>

    <!-- Display Categories -->
    <h2>All Categories</h2>
    <table border="1">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($categories as $category): ?>
                <tr>
                    <td><?= $category['id'] ?></td>
                    <td><?= htmlspecialchars($category['name']) ?></td>
                    <td>
                        <!-- Edit Category Form -->
                        <form method="post" style="display:inline;">
                            <input type="hidden" name="id" value="<?= $category['id'] ?>">
                            <input type="text" name="name" value="<?= htmlspecialchars($category['name']) ?>" required>
                            <button type="submit" name="edit_category">Edit</button>
                        </form>

                        <!-- Delete Category Form -->
                        <form method="post" style="display:inline;">
                            <input type="hidden" name="id" value="<?= $category['id'] ?>">
                            <button type="submit" name="delete_category" onclick="return confirm('Are you sure you want to delete this category?');">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
