<?php
// category_manager.php

// Include the database connection
require 'db_connection.php';

// Initialize message variable
$message = "";

// Handle Create
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'create') {
    $category_name = $_POST['category_name'];
    $sql = "INSERT INTO categories (category_name) VALUES ('$category_name')";
    if (mysqli_query($conn, $sql)) {
        $message = "Category created successfully.";
    } else {
        $message = "Error: " . mysqli_error($conn);
    }
}

// Handle Edit
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'edit') {
    $category_id = $_POST['category_id'];
    $category_name = $_POST['category_name'];
    $sql = "UPDATE categories SET category_name = '$category_name' WHERE id = $category_id";
    if (mysqli_query($conn, $sql)) {
        $message = "Category updated successfully.";
    } else {
        $message = "Error: " . mysqli_error($conn);
    }
}

// Handle Delete
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $category_id = $_GET['id'];
    $sql = "DELETE FROM categories WHERE id = $category_id";
    if (mysqli_query($conn, $sql)) {
        $message = "Category deleted successfully.";
    } else {
        $message = "Error: " . mysqli_error($conn);
    }
}

// Fetch Categories
$sql = "SELECT * FROM categories";
$result = mysqli_query($conn, $sql);
$categories = mysqli_fetch_all($result, MYSQLI_ASSOC);
?>

<meta name="viewport" content="width=device-width, initial-scale=1.0">
<?php include "header.php"; ?>
<style>/* General Styles */


/* General Styles */


/* Header Styles */
h1 {
    color: #4CAF50;
    font-size: 24px;
    text-align: center;
    margin-bottom: 15px;
    
}

h2 {
    color: #555;
    font-size: 20px;
    text-align: center;
    margin: 20px 0;
}

/* Form Styles */
form {
 
    padding: 15px;
    margin-bottom: 20px;
    border: 1px solid #ddd;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    width: 100%;
    max-width: 400px;
    box-sizing: border-box;
}

form input[type="text"],
form button {
    width: 100%;
    margin: 10px 0;
    padding: 12px;
    font-size: 16px;
    border: 1px solid #ccc;
    border-radius: 5px;
    box-sizing: border-box;
}

form button {
    background-color: #4CAF50;
    color: white;
    font-size: 16px;
    font-weight: bold;
    cursor: pointer;
    border: none;
    transition: background-color 0.3s ease;
}

form button:hover {
    background-color: #45a049;
}

/* Table Styles */
table {
    width: 100%;
    border-collapse: collapse;
    border: 1px solid #ddd;
    margin-top: 10px;
    background-color: #fff;
    font-size: 14px;
    text-align: left;
}

table th,
table td {
    padding: 10px;
    border: 1px solid #ddd;
    text-align: left;
    font-size: 14px;
}

table th {
 
    font-weight: bold;
}

table tr:nth-child(even) {
    background-color: #fff;
}

/* Responsive Table Design for Mobile */
table {
    display: block;
    overflow-x: auto;
    white-space: nowrap;
}

table th,
table td {
    display: inline-block;
    width: 150px; /* Adjust based on content */
}

/* Action Buttons */
.actions {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin-top: 10px;
}

.actions a,
.actions button {
    text-decoration: none;
    padding: 8px 10px;
    color: white;
    font-size: 14px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    transition: background-color 0.3s ease;
}

.actions a {
    background-color: #f44336;
}

.actions a:hover {
    background-color: #d32f2f;
}

.actions button {
    background-color: #2196F3;
}

.actions button:hover {
    background-color: #1976D2;
}

/* Mobile-First Design Adjustments */
@media (max-width: 768px) {
    h1,
    h2 {
        font-size: 18px;
    }

    form input[type="text"],
    form button {
        font-size: 14px;
        padding: 10px;
    }

    table th,
    table td {
        font-size: 12px;
        padding: 8px;
    }

    .actions a,
    .actions button {
        font-size: 12px;
        padding: 6px 8px;
    }
}

@media (max-width: 480px) {
    body {
        padding: 5px;
    }

    h1,
    h2 {
        font-size: 16px;
    }

    form input[type="text"],
    form button {
        font-size: 12px;
        padding: 8px;
    }

    .actions a,
    .actions button {
        font-size: 10px;
        padding: 5px 6px;
    }
}

</style>
    <h1>Category Manager</h1>
    <?php if (!empty($message)) echo "<p>$message</p>"; ?>

    <!-- Create Category -->
    <h2>Create Category</h2>
    <form method="POST" action="">
        <input type="hidden" name="action" value="create">
        <input type="text" name="category_name" placeholder="Category Name" required><br>
        <button type="submit">Create Category</button>
    </form>

    <!-- Display Categories -->
    <h2>Categories</h2>
    <table border="1">
        <tr>
         
            <th>Category Name</th>
            <th>Actions</th>
        </tr>
        <?php if (!empty($categories)): ?>
            <?php foreach ($categories as $category): ?>
                <tr>
                  
                    <td><?php echo htmlspecialchars($category['category_name']); ?></td>
                    <td>
                        <!-- Edit Form -->
                        <form method="POST" action="" style="display:inline;">
                            <input type="hidden" name="action" value="edit">
                            <input type="hidden" name="category_id" value="<?php echo $category['id']; ?>">
                            <input type="text" name="category_name" value="<?php echo htmlspecialchars($category['category_name']); ?>" required>
                            <button type="submit">Edit</button>
                        </form>
                        <!-- Delete Link -->
                        <a href="?action=delete&id=<?php echo $category['id']; ?>" onclick="return confirm('Are you sure you want to delete this category?');">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="3">No categories found.</td>
            </tr>
        <?php endif; ?>
    </table>

