<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            font-family: sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            min-height: 100vh;
            flex-direction: column;
        }

        /* Sidebar */
        .sidebar {
            background-color: #333;
            color: #fff;
            width: 250px;
            padding: 20px;
            position: fixed;
            top: 0;
            left: 0;
            height: 100%;
            overflow-y: auto;
            transition: transform 0.3s ease;
        }

        .sidebar a {
            display: block;
            padding: 15px;
            text-decoration: none;
            color: #fff;
            border-bottom: 1px solid #555;
            transition: all 0.3s ease;
        }

        .sidebar a:hover {
            background-color: #111;
        }

        /* Content Area */
        .content {
            flex: 1;
            padding: 30px;
            margin-left: 250px; /* Adjust for sidebar width */
            transition: margin-left 0.3s ease;
        }

        /* Toggle Button */
        .toggle-btn {
            display: none;
            background-color: #333;
            color: #fff;
            padding: 10px 15px;
            border: none;
            font-size: 18px;
            cursor: pointer;
            position: fixed;
            top: 10px;
            left: 10px;
            z-index: 1000;
        }

        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .toggle-btn {
                display: block;
            }

            .content {
                margin-left: 0;
                padding-top: 60px; /* Space for toggle button */
            }
        }
    </style>
</head>
<body>

    <button class="toggle-btn" onclick="toggleSidebar()"><i class="fas fa-bars"></i></button>

    <div class="sidebar" id="sidebar">
        <a href="dashboard.php"><i class="fas fa-home"></i> Home</a>
        <a href="consultation.php"><i class="fas fa-briefcase"></i> Consultancy</a>
        <a href="category.php"><i class="fas fa-list"></i>Product  Category</a>
        <a href="articlecategory.php"><i class="fas fa-list"></i>Articles  Category</a>
        
        <a href="postaticles.php"><i class="fas fa-newspaper"></i> Articles</a>
        <a href="post_recipe.php"><i class="fas fa-utensils"></i> Recipe</a>
        <a href="post_product.php"><i class="fas fa-shopping-cart"></i> Products</a>
        <a href="#"><i class="fas fa-users"></i> Customers</a>
    </div>

    <div class="content">
        <h1>Welcome to Admin Dashboard</h1>
        <p>This is your admin dashboard. Use the menu to navigate through the sections.</p>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('active');
        }
    </script>

</body> 
</html>
