<?php include("header.php"); ?>
<?php include("top.php"); ?>

<div class="offcanvas-overlay"></div>

<!-- ...:::Start Cart Section:::... -->
<div class="cart-section section-gap-top-30">
    <div class="container">
     
     
     
     
     
     
     
     
     
     
     






<?php
require 'db_connection.php';

// Check if the article ID is provided
if (!isset($_GET['id'])) {
    echo "Article not found.";
    exit;
}

$articleId = intval($_GET['id']);
$query = "SELECT articles.title, articles.details, articles.images, cateories.name AS category_name 
          FROM articles 
          JOIN cateories ON articles.category_id = cateories.id 
          WHERE articles.id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param('i', $articleId);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $article = $result->fetch_assoc();
    $images = json_decode($article['images'], true);
} else {
    echo "Article not found.";
    exit;
}
?>


    <title><?= htmlspecialchars($article['title']); ?></title>
    <style>
      
        .article-container {
            width: 100%;
            max-width: 500px;
            background: #fff;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .article-image {
            width: 300;
            height: 300;
            height: auto;
            display: block;
        }
        .article-content {
            padding: 20px;
        }
        .article-title {
            font-size: 24px;
            font-weight: bold;
            margin: 0 0 10px;
            text-align: center;
        }
        .article-details {
            font-size: 16px;
            line-height: 1.6;
            color: #333;
            white-space: pre-wrap; /* Keeps line breaks from the database */
        }
    </style>

    <div class="article-container">
        <!-- Display the article image -->
        <?php if (!empty($images)): ?>
            <img src="adm/<?= htmlspecialchars($images[0]); ?>" alt="Article Image" class="article-image">
        <?php else: ?>
            <div style="width:100%;height:200px;background:#ddd;display:flex;align-items:center;justify-content:center;">
                <span>No Image Available</span>
            </div>
        <?php endif; ?>

        <!-- Display the article title and details -->
        <div class="article-content">
            <h1 class="article-title"><?= htmlspecialchars($article['title']); ?></h1>
            <p class="article-details"><?= htmlspecialchars($article['details']); ?></p>
        </div>
    </div>














     
     
     
     
     
     
     
     
    </div>
</div>
<!-- ...:::End Cart Section:::... -->

<!-- JavaScript to Delete Item from Cart -->
<script>
document.querySelectorAll('.delete-item').forEach(button => {
    button.addEventListener('click', function () {
        const productId = this.getAttribute('data-product-id');
        let cart = JSON.parse(getCookie('cart') || '{}');
        
        delete cart[productId]; // Remove item from cart

        setCookie('cart', JSON.stringify(cart), 7); // Update cookie
        location.reload(); // Refresh page to reflect changes
    });
});

function getCookie(name) {
    const cookies = document.cookie.split(';').map(cookie => cookie.trim());
    for (const cookie of cookies) {
        if (cookie.startsWith(name + '=')) {
            return decodeURIComponent(cookie.split('=')[1]);
        }
    }
    return '';
}

function setCookie(name, value, days) {
    const date = new Date();
    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
    document.cookie = `${name}=${encodeURIComponent(value)}; expires=${date.toUTCString()}; path=/`;
}
</script>













  <div class="user-event-section">
    <!-- Start User Event Area -->
    <div class="col pos-relative">
        
        
        <div class="user-event-area">
             <div class="user-event">
                <a aria-label="Consultation" href="#" class="event-btn-link ">
                    <i class="fa-solid fa-comments"></i>
                    <span class="icon-label">Consultation</span>
                </a>
            </div>
            
            <div class="user-event">
                <a aria-label="Recipe" href="view.php" class="event-btn-link">
                    <i class="fa-solid fa-book"></i>
                    <span class="icon-label">Recipe</span>
                </a>
            </div>
            <div class="user-event">
                <a aria-label="Articles" href="article.php" class="event-btn-link pin">
                    <i class="fa-solid fa-newspaper"></i>
                    <span class="icon-label">Articles</span>
                </a>
            </div>
            <div class="user-event">
                <a aria-label="Ecommerce" href="home.php" class="event-btn-link">
                    <i class="fa-solid fa-bag-shopping"></i>
                    <span class="icon-label">Ecommerce</span>
                </a>
            </div>
            
           
        </div>
    </div>
    <!-- End User Event Area -->
</div>
<style>
.user-event-section {
    padding: 20px;
    background-color: #f9f9f9;
}

.user-event-area {
    display: flex;
    justify-content: space-around;
    align-items: center;
    gap: 20px;
}

.user-event {
    text-align: center;
}

.event-btn-link {
    text-decoration: none;
    color: #333;
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
}

.event-btn-link i {
    font-size: 30px;
    color: green;
    margin-bottom: 5px;
    transition: color 0.3s ease;
}

.icon-label {
    font-size: 14px;
    color: #555;
}

/* Highlight active menu item */
.event-btn-link.pin i {
    color: red; /* Active icon color */
}

.event-btn-link.pin .icon-label {
    color: #007bff; /* Active text color */
    font-weight: bold; /* Optional: make text bold */
}
</style>
 <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">









































