<?php
session_start();

// Check if session or cookies are set
if (isset($_SESSION['user_id']) || (isset($_COOKIE['phone']) && isset($_COOKIE['fullname']))) {
    // If cookies exist, you can set session variables from them (optional)
    if (!isset($_SESSION['user_id']) && isset($_COOKIE['phone']) && isset($_COOKIE['fullname'])) {
        $_SESSION['user_id'] = $_COOKIE['user_id'] ?? null; // Optional: Set `user_id` from a user ID cookie
        $_SESSION['phone'] = $_COOKIE['phone'];
        $_SESSION['fullname'] = $_COOKIE['fullname'];
    }

    // User is logged in; proceed to display the dashboard
    $userFullName = $_SESSION['fullname'];
    $userPhone = $_SESSION['phone'];
} else {
    // If no session or cookies, redirect to login.php
    header("Location: login.php");
    exit();
}
?>


    <?php include("header.php"); ?>


<body>

    <main class="main-wrapper">

   
      <?php include("top.php"); ?>
  

        <!-- ...:::Start Search & Filter Section:::... -->
        <div class="search-n-filter-section section-gap-top-25">
            <div class="container">
                <!-- Start Search & Filter Area -->
                <div class="search-n-filter-area">
                    <div class="search-box">

                        <div class="searchable select">
                            <input type="text" placeholder="Search..." onkeyup="filterFunction(this,event)">
                            <ul>
                           
                            <button class="btn search__btn" aria-label="Search Icon" type="submit">
                          

                        </div>

                        <a id="filter-trigger" aria-label="Filter Icon" class="filter_btn btn--radius btn--radical-red btn--color-white btn--box-shadow btn--size-40-40 btn--center btn--font-size-22"><i class="icon icon-carce-filter"></i></a>
                    </div>
                </div>
                <!-- End Search & Filter Area -->

              
            </div>
        </div>
       
       
       
       <?php
session_start(); 



// Include the database connection
require 'db_connection.php';

// Fetch all categories
$categories = mysqli_query($conn, "SELECT id, category_name FROM categories");

?>
       
       

        <!-- ...:::Start Catagories - 1 Section:::... -->
        <div class="catagories-section section-gap-top-50">
            <div class="container">
               <div class="catagories-area">
        <div class="catagories-nav-1">
            <!-- Slider main container -->
            <div class="swiper">
                <!-- Additional required wrapper -->
                <div class="swiper-wrapper">
                    <!-- Dynamically Generated Categories -->
                    <?php
                    if ($categories && mysqli_num_rows($categories) > 0) {
                        while ($category = mysqli_fetch_assoc($categories)) {
                            echo '
                            <div class="swiper-slide">
                                <a href="shop-category.php?category_id=' . $category['id'] . '" class="btn">
                                    <span class="icon"></span> ' . htmlspecialchars($category['category_name']) . '
                                </a>
                            </div>';
                        }
                    } else {
                        echo '<div class="swiper-slide">No Categories Found</div>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>

                <div class="catagories-wrapper catagories-shop-wrapper">

                   <div class="catagories-wrapper-content">
<?php
// Include the database connection
require 'db_connection.php';

// Get the page number from the AJAX request, default to 1
$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
$limit = 8; // Number of products to display per page
$offset = ($page - 1) * $limit; // Calculate the offset

// Fetch products with the limit and offset
$query = "
    SELECT 
        p.id AS product_id, 
        p.product_name, 
        p.current_price, 
        pi.image_path 
    FROM products p
    LEFT JOIN product_images pi ON p.id = pi.product_id
    GROUP BY p.id
    LIMIT $offset, $limit
";

$products = mysqli_query($conn, $query);

// Fetch the total number of products for pagination
$total_query = "SELECT COUNT(*) AS total_products FROM products";
$total_result = mysqli_query($conn, $total_query);
$total_row = mysqli_fetch_assoc($total_result);
$total_products = $total_row['total_products'];

// Calculate if more products are available
$show_load_more = ($total_products > $offset + $limit);

// Loop through products and display them
if ($products && mysqli_num_rows($products) > 0) {
    while ($product = mysqli_fetch_assoc($products)) {
        // Use a placeholder image if no image path exists
        $image_path = !empty($product['image_path']) ? htmlspecialchars($product['image_path']) : 'placeholder.jpg';
        ?>
        <div class="single-product-item product-item--style-1 product-item--bg-lime-green">
            <a href="single-product.php?product_id=<?= $product['product_id']; ?>" class="image">
                <img width="127" height="98" class="img-fluid" src="adm/<?= $image_path; ?>" alt="<?= htmlspecialchars($product['product_name']); ?>">
            </a>
            <div class="content">
                <div class="content--left">
                    <ul class="review-star">
                        <li class="items fill"><i class="icon icon-carce-star-full"></i></li>
                        <li class="items fill"><i class="icon icon-carce-star-full"></i></li>
                        <li class="items fill"><i class="icon icon-carce-star-full"></i></li>
                        <li class="items fill"><i class="icon icon-carce-star-full"></i></li>
                        <li class="items fill"><i class="icon icon-carce-star-full"></i></li>
                    </ul>
                    <a href="single-product.php?product_id=<?= $product['product_id']; ?>" class="title"><?= htmlspecialchars($product['product_name']); ?></a>
                    <span class="price">$<?= number_format($product['current_price'], 2); ?></span>
                </div>
                <div class="content--right">
                    <a href="wishlist.php?product_id=<?= $product['product_id']; ?>" aria-label="Wishlist" class="btn btn--size-33-33 btn--center btn--round btn--color-radical-red btn--bg-white btn--box-shadow">
                        <i class="icon icon-carce-heart"></i>
                    </a>
                </div>
            </div>
        </div>
        <?php 
    }
} else {
    echo '<p>No products found.</p>';
}

// If there are more products to load, show the "Load More" button
if ($show_load_more) {
    echo '<button class="load-more-btn">Load More</button>';
}

// Close the database connection
$conn->close();
?>
<script>$(document).ready(function() {
    let page = 1; // Start from the first page
    $(".load-more-btn").click(function() {
        page++; // Increment page number
        $.ajax({
            url: 'load_products.php',
            type: 'POST',
            data: { page: page },
            success: function(response) {
                if (response) {
                    $(".catagories-wrapper-content").append(response);
                }
            }
        });
    });
});
</script>
</div>

                   
                </div>
            </div>
        </div>
        <!-- ...:::Start Catagories - 1 Section:::... -->

        <!-- ...:::Start User Event Section:::... -->
      
      
      
      














<div class="user-event-section">
    <!-- Start User Event Area -->
    <div class="col pos-relative">
        
        
        <div class="user-event-area">
             <div class="user-event">
                <a aria-label="Consultation" href="#" class="event-btn-link pin">
                    <i class="fa-solid fa-comments"></i>
                    <span class="icon-label">Consultation</span>
                </a>
            </div>
            
            <div class="user-event">
                <a aria-label="Recipe" href="view.php" class="event-btn-link">
                    <i class="fa-solid fa-book"></i>
                    <span class="icon-label">Recipe</span>
                </a>
            </div>
            <div class="user-event">
                <a aria-label="Articles" href="article.php" class="event-btn-link">
                    <i class="fa-solid fa-newspaper"></i>
                    <span class="icon-label">Articles</span>
                </a>
            </div>
            <div class="user-event">
                <a aria-label="Ecommerce" href="home.php" class="event-btn-link">
                    <i class="fa-solid fa-bag-shopping"></i>
                    <span class="icon-label">Ecommerce</span>
                </a>
            </div>
            
           
        </div>
    </div>
    <!-- End User Event Area -->
</div>
<style>
.user-event-section {
    padding: 20px;
    background-color: #f9f9f9;
}

.user-event-area {
    display: flex;
    justify-content: space-around;
    align-items: center;
    gap: 20px;
}

.user-event {
    text-align: center;
}

.event-btn-link {
    text-decoration: none;
    color: #333;
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
}

.event-btn-link i {
    font-size: 30px;
    color: green;
    margin-bottom: 5px;
    transition: color 0.3s ease;
}

.icon-label {
    font-size: 14px;
    color: #555;
}

/* Highlight active menu item */
.event-btn-link.pin i {
    color: red; /* Active icon color */
}

.event-btn-link.pin .icon-label {
    color: #007bff; /* Active text color */
    font-weight: bold; /* Optional: make text bold */
}
</style>
 <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
   





      
      
      
      
      
      
      
      
      
      
      
      
      
      
        <!-- ...:::End User Event Section:::... -->

        <footer class="footer-section"></footer>
    </main>

    <!-- ::::::::::::::All JS Files here :::::::::::::: -->
    <!-- Global Vendor -->
    <script src="assets/js/vendor/modernizr-3.11.2.min.js"></script>
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="assets/js/vendor/jquery-migrate-3.3.2.min.js"></script>

    <!--Plugins JS-->
    <script src="assets/js/plugins/swiper-bundle.min.js"></script>
    <script src="assets/js/plugins/ion.rangeSlider.min.js"></script>

    <!-- Minify Version -->
    <!-- <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/plugins.min.js"></script> -->

    <!--Main JS (Common Activation Codes)-->
    <script src="assets/js/main.js"></script>
    <!-- <script src="assets/js/main.min.js"></script> -->

 

</body>

</html>