<?php
session_start();

require 'phpmailer/phpmailer/src/PHPMailer.php';
require 'phpmailer/phpmailer/src/Exception.php';
require 'phpmailer/phpmailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require 'db_connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = htmlspecialchars($_POST['fullname']);
    $phone = htmlspecialchars($_POST['phone']);
    $email = htmlspecialchars($_POST['email']);
    
    $address = htmlspecialchars($_POST['address']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    // Check if passwords match
    if ($password !== $confirm_password) {
        echo "Passwords do not match.";
        exit;
    }

    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Check if email or phone already exists in the customer table
    $sql_check = "SELECT * FROM customer WHERE email = '$email' OR phone = '$phone'";
    $result_check = $conn->query($sql_check);

    if ($result_check->num_rows > 0) {
        echo "Email or phone number already registered.";
        exit;
    }

    // Generate a verification code and token
    $verificationCode = rand(100000, 999999);
    $verificationToken = bin2hex(random_bytes(16));  // Generate a unique token

    // Insert new record into customer table
    $sql_insert = "INSERT INTO customer (fullname, phone, email,  address, password, verification_code, verified, verification_token) 
                   VALUES ('$name', '$phone', '$email', '$address', '$hashedPassword', '$verificationCode', 0, '$verificationToken')";

    if ($conn->query($sql_insert) === TRUE) {
        $_SESSION['verification_code'] = $verificationCode;
        $_SESSION['registered_mobile'] = $phone;
        $_SESSION['verified'] = false;

        // Generate verification link
        $verificationLink = "https://twinsapple.com.ng/verify.php?token=$verificationToken";

        // Send verification email using PHPMailer
        $mail = new PHPMailer(true);

        try {
            // Set mailer to use SMTP
            $mail->isSMTP();
            $mail->Host = 'mail.twinsapple.com.ng';       // Set the SMTP server
            $mail->SMTPAuth = true;                   // Enable SMTP authentication
            $mail->Username = 'customer@twinsapple.com.ng';  // SMTP username
            $mail->Password = '@mashaAllah1';    // SMTP password

            // Use SSL encryption with port 465
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;  // Enable SSL encryption
            $mail->Port = 465;  // Set SMTP port to 465 for SSL

            // Recipients
            $mail->setFrom('customer@twinsapple.com.ng', 'Twins Apple');
            $mail->addAddress($email, $name);  // Add a recipient

            // Content
            $mail->isHTML(true);  // Set email format to HTML
            $mail->Subject = 'Welcome to Twins apple';
            $mail->Body    = "
            <div style='font-family: Arial, sans-serif;'>
                <div style='background-color: #f2f2f2; padding: 20px; text-align: center;'>
                    <img src='https://saudat.com.ng/logo.png' alt='Logo' style='width: 200px;'>
                </div>
                <div style='background-color: #ffffff; padding: 20px; text-align: left;'>
                    <p>Dear <strong>$name</strong>,</p>
                    <p>Welcome to <strong>Twins apple</strong>.</p>
                    <p><strong>Your Verification Code:</strong> $verificationCode</p>
                    <p>Alternatively, click <a href='$verificationLink'>here</a> to verify your account.</p>
                    <p>We are excited to have you join us and look forward to your success within our network!</p>
                </div>
                <div style='background-color: #999; padding: 20px; text-align: center;'>
                    <p>Best regards,<br><strong>Twins apple</strong></p>
                    <p style='font-size: 12px; color: #888888;'>This is an automated message. Please do not reply.</p>
                </div>
            </div>";

            $mail->send();  // Send the email
            header("Location: verification.php");  // Redirect after sending
            exit;

        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
 
    } else {
        echo "Error: " . $sql_insert . "<br>" . $conn->error;
    }
}

$conn->close();
?>


<!DOCTYPE html>
<html lang="zxx">

<head>

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Carce- Mobile app eCommerce Template</title>
    <meta name="Googlebot" content="noindex">
    <meta name="description" content="Twins Apple.">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- ::::::::::::::Favicon icon::::::::::::::-->
    <link rel="shortcut icon" href="assets/images/favicon.ico" type="image/png">

    <!-- ::::::::::::::All Google Fonts::::::::::::::-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

    <!-- ::::::::::::::All CSS Files here :::::::::::::: -->
    <!-- Vendor CSS -->
    <link rel="stylesheet" href="assets/css/vendor/icomoon.css">

    <!-- Plugin CSS -->
    <link rel="stylesheet" href="assets/css/plugins/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/plugins/ion.rangeSlider.min.css">

    <!-- Style CSS -->
    <link rel="stylesheet" href="assets/css/style.css">



</head>

<body>

    <main class="main-wrapper">

        <!-- ...:::Start Login Section:::... -->
        <div class="login-section mt-115">
            <div class="container">
                <!-- Start User Event Area -->
                <div class="login-wrapper">
                    <div class="section-content">
                        <h1 class="title">Sign Up</h1>
                        <p>Kindly Register To Twins Apple.</p>
                    </div>
                    <form action="" method="POST" class="default-form-wrapper">
                        <ul class="default-form-list">
                            <li class="single-form-item">
                                <label for="name" class="visually-hidden">Name</label>
                                <input type="text" id="name" placeholder="Fullname"   name="fullname" required>
                                <span class="icon"><i class="icon icon-carce-user"></i></span>
                            </li> 
                            
                             <li class="single-form-item">
                                <label for="name" class="visually-hidden">Phone No</label>
                                <input type="number" id="name" placeholder="Phone No."   name="phone" required>
                                <span class="icon"><i class="icon icon-carce-user"></i></span>
                            </li> 
                            
                            
                            <li class="single-form-item">
                                <label for="email" class="visually-hidden">Email</label>
                                <input type="email" id="email" placeholder="email"  name="email" required>
                                <span class="icon"><i class="icon icon-carce-mail"></i></span>
                            </li>
                            
                            
                             <li class="single-form-item">
                                <label for="email" class="visually-hidden">Adress</label>
                                <input type="text" id="address" placeholder="Address"  name="address" required>
                                <span class="icon"><i class="icon icon-carce-mail"></i></span>
                            </li>
                            
                            
                            <li class="single-form-item">
                                <label for="password" class="visually-hidden">Password</label>
                                <input type="password" id="password" placeholder="password"  name="password" required>
                                <span class="icon"><i class="icon icon-carce-eye"></i></span>
                            </li>
                            <li class="single-form-item">
                                <label for="con-password" class="visually-hidden">Confirm Password</label>
                                <input type="password" id="con-password" placeholder="Confirm Password" name="confirm_password" required>
                                <span class="icon"><i class="icon icon-carce-eye"></i></span>
                            </li>
                        </ul>
                        
                        
                          <button type="submit"  id="submitButton" class="btn btn--block btn--radius btn--size-xlarge btn--color-white btn--bg-maya-blue text-center register-space-top">Sign Up
</button>

                        
                        
                    </form>
                  
                    
                </div>

                <div class="sign-account-text text-center">Already have an account? <a href="login.html" class="btn--color-radical-red">Sign Up</a></div>
                <!-- End User Event Area -->
                <div class="page-progress-wrapper">
                    <a href="index.html" class="btn--center btn--round btn--size-58-58 btn--color-white btn--radical-red progress-btn progress-btn--100"><i class="icon icon-carce-ios-arrow-forward"></i></a>
                </div>
            </div>
        </div>
        <!-- ...:::End User Event Section:::... -->

    </main>

    <!-- ::::::::::::::All JS Files here :::::::::::::: -->
    <!-- Global Vendor -->
    <script src="assets/js/vendor/modernizr-3.11.2.min.js"></script>
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="assets/js/vendor/jquery-migrate-3.3.2.min.js"></script>

    <!--Plugins JS-->
    <script src="assets/js/plugins/swiper-bundle.min.js"></script>
    <script src="assets/js/plugins/ion.rangeSlider.min.js"></script>

    <!-- Minify Version -->
    <!-- <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/plugins.min.js"></script> -->

    <!--Main JS (Common Activation Codes)-->
    <script src="assets/js/main.js"></script>
    <!-- <script src="assets/js/main.min.js"></script> -->

</body>

</html>