<?php
session_start();



// Include the database connection
require 'db_connection.php';

// Validate and fetch the recipe ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "Invalid recipe ID.";
    exit;
}
$recipe_id = intval($_GET['id']);

// Fetch the recipe details from the database
$stmt = $conn->prepare("SELECT heading, details, youtube_link, images, description, created_at FROM recipes WHERE id = ?");
$stmt->bind_param('i', $recipe_id);
$stmt->execute();
$result = $stmt->get_result();
$recipe = $result->fetch_assoc();
$stmt->close();

// Check if the recipe exists
if (!$recipe) {
    echo "Recipe not found.";
    exit;
}

// Decode images JSON
$images = json_decode($recipe['images'], true);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recipe Details - <?php echo htmlspecialchars($recipe['heading']); ?></title>
    <style>

/* Recipe Details Container */
.recipe-details {
    max-width: 90%;
    margin: 20px auto;
    padding: 20px;
    border-radius: 10px;
    background-color: #fff;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* Recipe Heading */
.recipe-details h1 {
    font-size: 24px;
    margin-bottom: 10px;
}

/* Recipe Images */
.recipe-images {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
}

.recipe-images img {
    width: 45%;
    margin-bottom: 10px;
    border-radius: 8px;
    object-fit: cover;
}

/* Recipe Details */
.recipe-details .details {
    margin-top: 20px;
}

.recipe-details .details h3 {
    font-size: 18px;
    margin-bottom: 10px;
}

/* Recipe Description */
.recipe-details .description {
    margin-top: 20px;
}

.recipe-details .description p {
    font-size: 16px;
    line-height: 1.8;
}

/* Recipe Video */
.recipe-video {
    margin-top: 20px;
}

.recipe-video iframe {
    width: 100%;
    height: 300px; /* Adjust height as needed */
}

/* Back Link */
.back-link {
    display: block;
    text-align: center;
    margin-top: 20px;
    color: #007BFF;
    text-decoration: none;
}
    </style>
</head>
<body>
    <?php include("header.php"); ?>
<?php include("top.php"); ?>

<div class="offcanvas-overlay"></div>

<!-- ...:::Start Cart Section:::... -->
<div class="cart-section section-gap-top-30">
    <div class="container">
    
    <div class="recipe-details">
        <h1><?php echo htmlspecialchars($recipe['heading']); ?></h1>
        
         <div class="recipe-images">
          
            <?php if (!empty($images)): ?>
                <?php foreach ($images as $image): ?>
                    <?php if (isset($image['path'])): ?>
                        <img src="adm/<?php echo htmlspecialchars($image['path']); ?>" alt="Recipe Image">
                    <?php endif; ?>
                <?php endforeach; ?>
            <?php else: ?>
                <p>No images available for this recipe.</p>
            <?php endif; ?>
        </div>
        
        <div class="created-date">Created on: <?php echo htmlspecialchars($recipe['created_at']); ?></div>

        <div class="details">
            <h3>Details:</h3>
            <!-- Display CKEditor content -->
            <div><?php echo $recipe['details']; ?></div>
        </div>
        
        <div class="description">

            <p><?php echo nl2br(htmlspecialchars($recipe['description'])); ?></p>
        </div>

       

        <?php if (!empty($recipe['youtube_link'])): ?>
            <div class="recipe-video">
                <h3>Video:</h3>
                <?php
                // Extract the YouTube video ID from the URL
                $youtube_id = null;
                if (preg_match('/(?:youtu\.be\/|youtube\.com\/(?:watch\?v=|embed\/|v\/|shorts\/))([\w\-]+)/', $recipe['youtube_link'], $matches)) {
                    $youtube_id = $matches[1];
                }
                ?>
                <?php if ($youtube_id): ?>
                    <iframe src="https://www.youtube.com/embed/<?php echo htmlspecialchars($youtube_id); ?>" allowfullscreen></iframe>
                <?php else: ?>
                    <p>Invalid YouTube link.</p>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <a href="view.php" class="back-link">&larr; Back to Recipes</a>
    </div>
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
        <div class="user-event-section">
    <!-- Start User Event Area -->
    <div class="col pos-relative">
        
        
        <div class="user-event-area">
             <div class="user-event">
                <a aria-label="Consultation" href="#" class="event-btn-link ">
                    <i class="fa-solid fa-comments"></i>
                    <span class="icon-label">Consultation</span>
                </a>
            </div>
            
            <div class="user-event">
                <a aria-label="Recipe" href="view.php" class="event-btn-link pin">
                    <i class="fa-solid fa-book"></i>
                    <span class="icon-label">Recipe</span>
                </a>
            </div>
            <div class="user-event">
                <a aria-label="Articles" href="article.php" class="event-btn-link">
                    <i class="fa-solid fa-newspaper"></i>
                    <span class="icon-label">Articles</span>
                </a>
            </div>
            <div class="user-event">
                <a aria-label="Ecommerce" href="home.php" class="event-btn-link">
                    <i class="fa-solid fa-bag-shopping"></i>
                    <span class="icon-label">Ecommerce</span>
                </a>
            </div>
            
           
        </div>
    </div>
    <!-- End User Event Area -->
</div>
<style>
.user-event-section {
    padding: 20px;
    background-color: #f9f9f9;
}

.user-event-area {
    display: flex;
    justify-content: space-around;
    align-items: center;
    gap: 20px;
}

.user-event {
    text-align: center;
}

.event-btn-link {
    text-decoration: none;
    color: #333;
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
}

.event-btn-link i {
    font-size: 30px;
    color: green;
    margin-bottom: 5px;
    transition: color 0.3s ease;
}

.icon-label {
    font-size: 14px;
    color: #555;
}

/* Highlight active menu item */
.event-btn-link.pin i {
    color: red; /* Active icon color */
}

.event-btn-link.pin .icon-label {
    color: #007bff; /* Active text color */
    font-weight: bold; /* Optional: make text bold */
}
</style>
 <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
</body>
</html>
