<?php
session_start(); 

// Include the database connection
require 'db_connection.php';

// Fetch all categories
$categories = mysqli_query($conn, "SELECT id, category_name FROM categories");
?>

<!DOCTYPE html>
<html lang="zxx">

<head>

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Carce- Mobile app eCommerce Template</title>
    <meta name="Googlebot" content="noindex">
    <meta name="description" content="Carce is an exclusive ecommerce mobile app template with 2 distinct layouts. This superb mobile app template for ecommerce embodies a professional-looking mobile website design while providing tons of features.">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- ::::::::::::::Favicon icon::::::::::::::-->
    <link rel="shortcut icon" href="assets/images/favicon.ico" type="image/png">

    <!-- ::::::::::::::All Google Fonts::::::::::::::-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

    <!-- ::::::::::::::All CSS Files here :::::::::::::: -->
    <!-- Vendor CSS -->
    <link rel="stylesheet" href="assets/css/vendor/icomoon.css">

    <!-- Plugin CSS -->
    <link rel="stylesheet" href="assets/css/plugins/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/plugins/ion.rangeSlider.min.css">

    <!-- Style CSS -->
    <link rel="stylesheet" href="assets/css/style.css">



</head>

<body>

    <main class="main-wrapper">

   
        <div class="header-section">
            <div class="container">
                <!-- Start User Event Area -->
                <div class="header-area">
                    <div class="header-top-area header-top-area--style-1">
                        <ul class="event-list">
                            <li class="list-item"><a href="#mobile-menu-offcanvas" area-label="mobile menu offcanvas svg icon" class="btn btn--size-33-33 btn--center btn--round btn--color-radical-red btn--bg-white btn--box-shadow main-menu offcanvas-toggle offside-menu">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewbox="0 0 16 16">
                                        <g id="Group_1" data-name="Group 1" transform="translate(-28 -63)">
                                            <path id="Rectangle_3" data-name="Rectangle 3" d="M0,0H5A2,2,0,0,1,7,2V5A2,2,0,0,1,5,7H2A2,2,0,0,1,0,5V0A0,0,0,0,1,0,0Z" transform="translate(28 63)" fill="#ff375f"></path>
                                            <path id="Rectangle_6" data-name="Rectangle 6" d="M2,0H5A2,2,0,0,1,7,2V5A2,2,0,0,1,5,7H0A0,0,0,0,1,0,7V2A2,2,0,0,1,2,0Z" transform="translate(28 72)" fill="#ff375f"></path>
                                            <path id="Rectangle_4" data-name="Rectangle 4" d="M2,0H7A0,0,0,0,1,7,0V5A2,2,0,0,1,5,7H2A2,2,0,0,1,0,5V2A2,2,0,0,1,2,0Z" transform="translate(37 63)" fill="#ff375f"></path>
                                            <path id="Rectangle_5" data-name="Rectangle 5" d="M2,0H5A2,2,0,0,1,7,2V7A0,0,0,0,1,7,7H2A2,2,0,0,1,0,5V2A2,2,0,0,1,2,0Z" transform="translate(37 72)" fill="#ff375f"></path>
                                        </g>
                                    </svg>
                                </a></li>
                            <li class="list-item">
                                <h2 class="title text-center">Twins Apple</h2>
                            </li>
                            <li class="list-item">
                                <ul class="list-child">
                                    <li class="list-item">
                                        <span class="notch-bg notch-bg--sunset-orange"></span>
                                        <a href="cart.html" area-label="Cart" class="btn btn--size-33-33 btn--center btn--round btn--color-radical-red btn--bg-white btn--box-shadow"><i class="icon icon-carce-cart"></i></a>
                                    </li>
                                    <li class="list-item">
                                        <span class="notch-bg notch-bg--emerald"></span>
                                        <a href="#profile-menu-offcanvas" area-label="User" class="btn btn--size-33-33 btn--center btn--round offcanvas-toggle offside-menu">
                                            <img class="img-fluid" height="33" width="33" src="assets/images/header-top-user-img.jpg" alt="user image"></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
                <!-- End User Event Area -->
            </div>
        </div>
        <!-- ...:::End User Event Section:::... -->

        <!--  Start Offcanvas Mobile Menu Section -->
        <div id="mobile-menu-offcanvas" class="offcanvas offcanvas-leftside offcanvas-mobile-menu-section">
            <!-- Start Offcanvas Header -->
            <div class="offcanvas-header flex-end">

                <div class="logo">
                    <a href="logout.php"><img class="img-fluid" width="147" height="26" src="assets/images/logo.png" alt="image"></a> 
                </div>

                <button class="offcanvas-close" aria-label="offcanvas svg icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="5.973" height="10.449" viewbox="0 0 5.973 10.449">
                        <path id="Icon_ionic-ios-arrow-back" data-name="Icon ionic-ios-arrow-back" d="M13.051,11.417,17,7.466a.747.747,0,0,0-1.058-1.054l-4.479,4.476a.745.745,0,0,0-.022,1.03l4.5,4.507A.747.747,0,1,0,17,15.37Z" transform="translate(-11.251 -6.194)"></path>
                    </svg>
                </button>
            </div>
            <!-- End Offcanvas Header -->

            <!-- Start Offcanvas Mobile Menu Wrapper -->
            <div class="offcanvas-mobile-menu-wrapper">
                <!-- Start Mobile Menu  -->
                <div class="mobile-menu-bottom">
                    <!-- Start Mobile Menu Nav -->
                    <div class="offcanvas-menu">
                        <ul>
                            <li>
                                <a href="index.html"><span>Home</span></a>
                            </li>
                            <li>
                                <a href="#"><span>Twins Apple</span></a>
                                <ul class="mobile-sub-menu">
                                    <li><a href="shop.html">Shop</a></li>
                                    <li><a href="single-product.html">Product</a></li>
                                    <li><a href="shop-category.html">Shop Category</a></li>
                                </ul>

                            </li>
                            <li>
                                <a href="#"><span>Pages</span></a>
                                <ul class="mobile-sub-menu">
                                    <li><a href="chat.html">Chat</a></li>
                                    <li><a href="cart.html">Cart</a></li>
                                    <li><a href="wishlist.html">Wishlist</a></li>
                                    <li><a href="order.html">Order</a></li>
                                    <li><a href="login.html">Login</a></li>
                                    <li><a href="register.html">Register</a></li>
                                </ul>
                            </li>
                        </ul>
                    </div> <!-- End Mobile Menu Nav -->
                </div> <!-- End Mobile Menu -->

                <!-- Start Mobile contact Info -->
                <div class="mobile-contact-info">
                    <address class="address">
                        <span>Address: 4710-4890 Breckinridge St, Fayettevill</span>
                        <span>Call Us: (+800) 345 678, (+800) 123 456</span>
                        <span>Email: yourmail@mail.com</span>
                    </address>
                </div>
                <!-- End Mobile contact Info -->

            </div> <!-- End Offcanvas Mobile Menu Wrapper -->
        </div> <!-- ...:::: End Offcanvas Mobile Menu Section:::... -->

        <!--  Start Offcanvas Profile Menu Section -->
        <div id="profile-menu-offcanvas" class="offcanvas offcanvas-rightside">
            <!-- Start Offcanvas Header -->
            <div class="offcanvas-header flex-start offcanvas-modify">
                <button class="offcanvas-close" aria-label="offcanvas svg icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="5.973" height="10.449" viewbox="0 0 5.973 10.449">
                        <path id="Icon_ionic-ios-arrow-back" data-name="Icon ionic-ios-arrow-back" d="M13.051,11.417,17,7.466a.747.747,0,0,0-1.058-1.054l-4.479,4.476a.745.745,0,0,0-.022,1.03l4.5,4.507A.747.747,0,1,0,17,15.37Z" transform="translate(-11.251 -6.194)"></path>
                    </svg>
                </button>
                <span>Home</span>

            </div> <!-- End Offcanvas Header -->
            <!-- Start Offcanvas Mobile Menu Wrapper -->
<?php
session_start();

// Include your database connection file
require 'db_connection.php';

// Check if the user is logged in
if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id']; // Get the user ID from the session

    // Prepare the SQL query to fetch the wallet balance from the customer table
    $sql_wallet = "SELECT wallet FROM customer WHERE id = ?";
    $stmt = $conn->prepare($sql_wallet);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result_wallet = $stmt->get_result();

    if ($result_wallet->num_rows > 0) {
        // Fetch the wallet balance
        $row = $result_wallet->fetch_assoc();
        $wallet = $row['wallet']; // Wallet balance
    } else {
        $wallet = 0; // Default to 0 if no wallet is found
    }

    // Close the prepared statement
    $stmt->close();
} else {
    $wallet = 0; // Default to 0 if the user is not logged in
}

// Close the database connection
$conn->close();
?>
<div class="offcanvas-profile-menu-wrapper">
    <!-- ...:::Start Profile Card Section:::... -->
<div class="offcanvas-profile-menu-wrapper">
    <!-- ...:::Start Profile Card Section:::... -->
    <div class="profile-card-section section-gap-top-25">
        <div class="profile-card-wrapper">
            <div class="image">
                <img class="img-fluid" width="96" height="96" src="assets/images/user/user-profile.png" alt="image">
            </div>
            <div class="content">
                <h2 class="name"><?php echo htmlspecialchars($_SESSION['fullname']); ?></h2>
                <span class="email"><?php echo htmlspecialchars($_SESSION['email']); ?></span>
               
            </div>
            <div class="profile-shape profile-shape-1">
                <img class="img-fluid" width="61" height="50" src="assets/images/profile-shape-1.svg" alt="image">
            </div>
            <div class="profile-shape profile-shape-2">
                <img class="img-fluid" width="48" height="59" src="assets/images/profile-shape-2.svg" alt="image">
            </div>
        </div>
    </div>
    <!-- ...:::End Profile Card Section:::... -->
</div>

                <!-- ...:::End Profile Card Section:::... -->

                <!-- ...:::Start Profile Details Section:::... -->
                <div class="profile-details-section section-gap-top-30">
                    <div class="profile-details-wrapper">
                        <div class="profile-details-top">
                            <div class="left">
                                <span class="text">Wallet Balance</span>
                               
                                                                <span class="price"> <?php echo "$" . number_format($wallet, 2); ?></span>
                            </div>
                            <div class="right">
                                <button aria-label="Wishlist" class="btn btn--size-58-58 btn--font-size-22 btn--center btn--round btn--color-radical-red btn--bg-white btn--box-shadow"><i class="icon icon-carce-heart"></i></button>
                            </div>
                        </div>
                        <div class="profile-details-bottom">
                            <ul class="profile-user-list">
                                <li class="profile-list-item">
                                    <ul class="profile-single-list">
                                        <li class="list-item">
                                            <span class="title">Setting</span>
                                        </li>
                                        <li class="list-item">
                                            <a href="profile-settings.html" class="profile-link"><span class="icon"><i class="icon icon-carce-user"></i></span>Account Setting</a>
                                        </li>
                                        <li class="list-item">
                                            <a href="checkout.html" class="profile-link"><span class="icon"><i class="icon icon-carce-briefcase"></i></span>Billing & Payment</a>
                                        </li>
                                        <li class="list-item">
                                            <a href="notification.html" class="profile-link"><span class="icon"><i class="icon icon-carce-bell"></i></span>Notification</a>
                                        </li>
                                    </ul>
                                </li>

                                <li class="profile-list-item">
                                    <ul class="profile-single-list">
                                        <li class="list-item">
                                            <a href="logout.php" class="profile-link"><span class="icon"><i class="icon icon-carce-login"></i></span>Log Out</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- ...:::End Profile Details Section:::... -->
            </div> <!-- End Offcanvas Mobile Menu Wrapper -->
        </div> <!-- ...:::: End Offcanvas Profile Menu Section:::... -->

        <div class="offcanvas-overlay"></div>

        <!-- ...:::Start Search & Filter Section:::... -->
        <div class="search-n-filter-section section-gap-top-25">
            <div class="container">
                <!-- Start Search & Filter Area -->
                <div class="search-n-filter-area">
                    <div class="search-box">

                        <div class="searchable select">
                            <input type="text" placeholder="Search..." onkeyup="filterFunction(this,event)">
                            <ul>
                           
                            <button class="btn search__btn" aria-label="Search Icon" type="submit">
                          

                        </div>

                        <a id="filter-trigger" aria-label="Filter Icon" class="filter_btn btn--radius btn--radical-red btn--color-white btn--box-shadow btn--size-40-40 btn--center btn--font-size-22"><i class="icon icon-carce-filter"></i></a>
                    </div>
                </div>
                <!-- End Search & Filter Area -->

              
            </div>
        </div>
       
       
       
       <?php
session_start(); 



// Include the database connection
require 'db_connection.php';

// Fetch all categories
$categories = mysqli_query($conn, "SELECT id, category_name FROM categories");

?>
       
       

        <!-- ...:::Start Catagories - 1 Section:::... -->
        <div class="catagories-section section-gap-top-50">
            <div class="container">
               <div class="catagories-area">
        <div class="catagories-nav-1">
            <!-- Slider main container -->
            <div class="swiper">
                <!-- Additional required wrapper -->
                <div class="swiper-wrapper">
                    <!-- Dynamically Generated Categories -->
                    <?php
                    if ($categories && mysqli_num_rows($categories) > 0) {
                        while ($category = mysqli_fetch_assoc($categories)) {
                            echo '
                            <div class="swiper-slide">
                                <a href="shop-category.php?category_id=' . $category['id'] . '" class="btn">
                                    <span class="icon"></span> ' . htmlspecialchars($category['category_name']) . '
                                </a>
                            </div>';
                        }
                    } else {
                        echo '<div class="swiper-slide">No Categories Found</div>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>

                <div class="catagories-wrapper catagories-shop-wrapper">

                   <div class="catagories-wrapper-content">
 <?php
                    // Get the page number and category_id from the request
                    $page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
                    $category_id = isset($_GET['category_id']) ? (int)$_GET['category_id'] : null;
                    $limit = 8; // Number of products to display per page
                    $offset = ($page - 1) * $limit;

                    // Build the product query
                    $query = "
                        SELECT 
                            p.id AS product_id, 
                            p.product_name, 
                            p.current_price, 
                            pi.image_path 
                        FROM products p
                        LEFT JOIN product_images pi ON p.id = pi.product_id
                        WHERE " . ($category_id ? "p.category_id = $category_id AND" : "") . " 1=1
                        GROUP BY p.id
                        LIMIT $offset, $limit
                    ";

                    $products = mysqli_query($conn, $query);

                    // Fetch total products for pagination
                    $total_query = "SELECT COUNT(*) AS total_products FROM products " . ($category_id ? "WHERE category_id = $category_id" : "");
                    $total_result = mysqli_query($conn, $total_query);
                    $total_row = mysqli_fetch_assoc($total_result);
                    $total_products = $total_row['total_products'];
                    $show_load_more = ($total_products > $offset + $limit);

                    // Display products
                    if ($products && mysqli_num_rows($products) > 0) {
                        while ($product = mysqli_fetch_assoc($products)) {
                            $image_path = !empty($product['image_path']) ? htmlspecialchars($product['image_path']) : 'placeholder.jpg';
                            ?>
                            <div class="single-product-item product-item--style-1">
                                <a href="single-product.php?product_id=<?= $product['product_id']; ?>" class="image">
                                    <img width="127" height="98" class="img-fluid" src="adm/<?= $image_path; ?>" alt="<?= htmlspecialchars($product['product_name']); ?>">
                                </a>
                                <div class="content">
                                    <div class="content--left">
                                        <a href="single-product.php?product_id=<?= $product['product_id']; ?>" class="title"><?= htmlspecialchars($product['product_name']); ?></a>
                                        <span class="price">$<?= number_format($product['current_price'], 2); ?></span>
                                    </div>
                                    <div class="content--right">
                                        <a href="wishlist.php?product_id=<?= $product['product_id']; ?>" class="btn">Wishlist</a>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    } else {
                        echo '<p>No products found.</p>';
                    }

                    // Show "Load More" button
                    if ($show_load_more) {
                        echo '<button class="load-more-btn">Load More</button>';
                    }
                    ?>
<script>
        $(document).ready(function() {
            let page = 1;
            $(".load-more-btn").click(function() {
                page++;
                $.ajax({
                    url: 'shop-category.php',
                    type: 'POST',
                    data: { page: page, category_id: <?= $category_id ?: 'null'; ?> },
                    success: function(response) {
                        $(".catagories-wrapper-content").append(response);
                    }
                });
            });
        });
    </script>
</div>

                   
                </div>
            </div>
        </div>
        <!-- ...:::Start Catagories - 1 Section:::... -->

        <!-- ...:::Start User Event Section:::... -->
        <div class="user-event-section">
            <!-- Start User Event Area -->
            <div class="col pos-relative">

                <div class="user-event-area">
                    <div class="user-event user-event--left">
                        <a area-label="event link icon" href="index.html" class="event-btn-link"><i class="icon icon-carce-home"></i></a>
                        <a area-label="wishlist icon" href="wishlist.html" class="event-btn-link"><i class="icon icon-carce-heart"></i></a>
                    </div>
                    <div class="user-event user-event--center">
                        <a area-label="cart icon" href="cart.html" class="event-btn-link"> Test<i class="icon icon-carce-cart"></i></a>
                    </div>
                    <div class="user-event user-event--right">
                        <a area-label="order icon" href="order.html" class="event-btn-link"><i class="icon icon-carce-compare"></i></a>
                        <a area-label="chat icon" href="chat.html" class="event-btn-link"><i class="icon icon-carce-bubbles2"></i></a>
                    </div>
                </div>
            </div>
            <!-- End User Event Area -->
        </div>
        <!-- ...:::End User Event Section:::... -->

        <footer class="footer-section"></footer>
    </main>

    <!-- ::::::::::::::All JS Files here :::::::::::::: -->
    <!-- Global Vendor -->
    <script src="assets/js/vendor/modernizr-3.11.2.min.js"></script>
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="assets/js/vendor/jquery-migrate-3.3.2.min.js"></script>

    <!--Plugins JS-->
    <script src="assets/js/plugins/swiper-bundle.min.js"></script>
    <script src="assets/js/plugins/ion.rangeSlider.min.js"></script>

    <!-- Minify Version -->
    <!-- <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/plugins.min.js"></script> -->

    <!--Main JS (Common Activation Codes)-->
    <script src="assets/js/main.js"></script>
    <!-- <script src="assets/js/main.min.js"></script> -->

 

</body>

</html>