<?php
session_start();

require 'db_connection.php'; // Your database connection file

// Check if verification code form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_SESSION['user_id'];
    // Get user-entered verification code
    $userVerificationCode = $_POST['verification_code'];

    // Retrieve stored verification code from session
    $storedVerificationCode = isset($_SESSION['verification_code']) ? $_SESSION['verification_code'] : '';

    // Check if user-entered code matches the stored code
    if ($userVerificationCode == $storedVerificationCode) {
        // Update verification status in session
        $_SESSION['verified'] = true;

        // Update verification status in database
        $phone = $_SESSION['registered_mobile']; 
        $sqlUpdate = "UPDATE customer SET verified = 1 WHERE phone = '$phone'";
        if ($conn->query($sqlUpdate) === false) {
            echo "Error updating verification status: " . $conn->error;
        }

        // Redirect to dashboard or success page
        header("Location: success.php");
        exit;
    } else {
        // Verification code does not match
        $verificationError = "Invalid verification code. Please try again.";
    }
}

// Close database connection
$conn->close();
?>  

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">

    <link rel="stylesheet" href="afonts/fonts.css">
    <link rel="stylesheet" href="afonts/font-icons.css">
    <link rel="stylesheet" href="acss/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="acss/styles.css"/>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="shortcut icon" href="images/logo/48.png" />
    <link rel="apple-touch-icon-precomposed" href="images/logo/48.png" />
    <title>Sign-Up Verification</title>

    <style>
        body {
            background-image: url("images/bg.jpg");
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center center;
            height: 100vh;
            margin: 0;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .container {
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .content {
            background-color: white;
            width: 400px;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .form-title {
            text-align: center;
            font-size: 24px;
            margin-bottom: 20px;
        }

        form {
            display: flex;
            flex-direction: column;
        }

        input[type="number"] {
            border: none;
            border-bottom: 1px solid black;
            outline: none;
            margin: 10px 0;
            padding: 10px;
            font-size: 16px;
        }

        button {
            color: #fff;
            background-color: #4caf50;
            height: 40px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-top: 20px;
            font-size: 16px;
            text-align: center;
            transition: background-color 0.4s;
        }

        button:hover {
            background-color: #333;
        }

        .error-message {
            color: red;
            text-align: center;
            margin-bottom: 10px;
        }
    </style>
</head>

<body>

    <div class="container">
        <div class="content">
            <?php if (isset($verificationError)) : ?>
                <p class="error-message"><?php echo $verificationError; ?></p>
            <?php endif; ?>

            <h1 class="form-title">Verify Code</h1>
          <p>Kindly check your email inbox or spam folder.</p>

            <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" id="registrationForm" autocomplete="off">
                <input type="number" id="verification_code" name="verification_code" placeholder="Enter Verification Code" required>
                <button type="submit">Confirm Verify</button>
            </form>
        </div>
    </div>

    <script type="text/javascript" src="ajs/bootstrap.min.js"></script>
    <script type="text/javascript" src="ajs/jquery.min.js"></script>
    <script type="text/javascript" src="ajs/main.js"></script>
</body>
</html>
