<?php


// Include the database connection
require 'db_connection.php';

// Fetch all recipes from the database
$stmt = $conn->prepare("SELECT id, heading, images FROM recipes");
$stmt->execute();
$result = $stmt->get_result();
$recipes = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>


    <style>
        .recipe-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }

        .recipe {
            border: 1px solid #ccc;
            border-radius: 8px;
            padding: 10px;
            width: 300px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .recipe img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
        }

        .recipe h3 {
            margin: 10px 0;
        }

        .recipe a {
            display: block;
            margin-top: 10px;
            color: #007BFF;
            text-decoration: none;
        }

        .recipe a:hover {
            text-decoration: underline;
        }
    </style>

<?php include("header.php"); ?>
<?php include("top.php"); ?>

<div class="offcanvas-overlay"></div>

<!-- ...:::Start Cart Section:::... -->
<div class="cart-section section-gap-top-30">
    <div class="container">

<center>

  
        <?php foreach ($recipes as $recipe): ?>
            <div class="recipe">
                <h3><?php echo htmlspecialchars($recipe['heading']); ?></h3>
                <?php 
                $images = json_decode($recipe['images'], true);
                if (!empty($images) && isset($images[0]['path'])): ?>
                    <a href="repiciedetail.php?id=<?php echo $recipe['id']; ?>">
                        <img src="adm/<?php echo $images[0]['path']; ?>" alt="Recipe Image">
                    </a>
                <?php else: ?>
                    <p>No image available</p>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
 
    
    </center>
    </div>
    </div>
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    <div class="user-event-section">
    <!-- Start User Event Area -->
    <div class="col pos-relative">
        
        
        <div class="user-event-area">
             <div class="user-event">
                <a aria-label="Consultation" href="#" class="event-btn-link ">
                    <i class="fa-solid fa-comments"></i>
                    <span class="icon-label">Consultation</span>
                </a>
            </div>
            
            <div class="user-event">
                <a aria-label="Recipe" href="view.php" class="event-btn-link pin">
                    <i class="fa-solid fa-book"></i>
                    <span class="icon-label">Recipe</span>
                </a>
            </div>
            <div class="user-event">
                <a aria-label="Articles" href="article.php" class="event-btn-link">
                    <i class="fa-solid fa-newspaper"></i>
                    <span class="icon-label">Articles</span>
                </a>
            </div>
            <div class="user-event">
                <a aria-label="Ecommerce" href="home.php" class="event-btn-link">
                    <i class="fa-solid fa-bag-shopping"></i>
                    <span class="icon-label">Ecommerce</span>
                </a>
            </div>
            
           
        </div>
    </div>
    <!-- End User Event Area -->
</div>
<style>
.user-event-section {
    padding: 20px;
    background-color: #f9f9f9;
}

.user-event-area {
    display: flex;
    justify-content: space-around;
    align-items: center;
    gap: 20px;
}

.user-event {
    text-align: center;
}

.event-btn-link {
    text-decoration: none;
    color: #333;
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
}

.event-btn-link i {
    font-size: 30px;
    color: green;
    margin-bottom: 5px;
    transition: color 0.3s ease;
}

.icon-label {
    font-size: 14px;
    color: #555;
}

/* Highlight active menu item */
.event-btn-link.pin i {
    color: red; /* Active icon color */
}

.event-btn-link.pin .icon-label {
    color: #007bff; /* Active text color */
    font-weight: bold; /* Optional: make text bold */
}
</style>
 <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
   




