<?php
// create_category.php

// Include the database connection
require 'db_connection.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $category_name = $_POST['category_name'];
    
    try {
        // Prepare the SQL statement
        $stmt = $pdo->prepare('INSERT INTO categories (category_name) VALUES (:category_name)');
        
        // Bind parameters
        $stmt->bindParam(':category_name', $category_name);
        
        // Execute the statement
        $stmt->execute();
        
        echo "Category created successfully.";
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Create Category</title>
</head>
<body>
    <form method="POST" action="">
        <input type="text" name="category_name" placeholder="Category Name" required><br>
        <button type="submit">Create Category</button>
    </form>
</body>
</html>
