<?php
// Include database connection
require 'db_connection.php';

// Check if category_id is sent via POST
if (isset($_POST['category_id'])) {
    $category_id = intval($_POST['category_id']); // Sanitize input
    
    // Prepare SQL query to fetch subcategories
    $stmt = $conn->prepare("SELECT id, subcategory_name FROM subcategories WHERE category_id = ?");
    $stmt->bind_param('i', $category_id); // Bind category_id to the query
    $stmt->execute();
    
    $result = $stmt->get_result();
    
    // Check if there are any subcategories for the selected category
    if ($result->num_rows > 0) {
        echo '<option value="">Select Subcategory</option>'; // Default option
        // Loop through results and output subcategory options
        while ($row = $result->fetch_assoc()) {
            echo '<option value="' . $row['id'] . '">' . $row['subcategory_name'] . '</option>';
        }
    } else {
        echo '<option value="">Invalid category</option>'; // No subcategories found
    }
    
    $stmt->close(); // Close the prepared statement
} else {
    echo '<option value="">Invalid category</option>'; // No category_id in POST request
}
?>
