why i have select tailoring from my category but input size and color is not display <?php
// Include the database connection
require '../admin/db_connection.php';

// Start the session and get the store_id
session_start();
$store_id = $_SESSION['store_id']; // assuming store_id is stored in the session

// Fetch all categories
$categories = mysqli_query($conn, 'SELECT id, category_name FROM categories');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get posted data
    $category_id = $_POST['category_id'];
    $subcategory_id = $_POST['subcategory_id'];
    $product_name = $_POST['product_name'];
    $old_price = $_POST['old_price'];
    $current_price = $_POST['current_price'];
    $quantity = $_POST['quantity'];
    $size = !empty($_POST['size']) ? $_POST['size'] : null;
    $color = !empty($_POST['color']) ? $_POST['color'] : null;
    $mode = $_POST['mode'];
    $latitude = (float)$_POST["latitude"];
    $longitude = (float)$_POST["longitude"];

    // Calculate discount percentage
    $discount = ($old_price - $current_price) / $old_price * 100;

    try {
        // Insert product into the database, including store_id
        $stmt = $conn->prepare('INSERT INTO products (store_id, category_id, subcategory_id, product_name, old_price, current_price, discount, quantity, size, color, mode, latitude, longitude) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
        $stmt->bind_param("iiissddisssdd", $store_id, $category_id, $subcategory_id, $product_name, $old_price, $current_price, $discount, $quantity, $size, $color, $mode, $latitude, $longitude);
        $stmt->execute();

        // Get the last inserted product ID
        $product_id = $stmt->insert_id;

        // Process the uploaded image
      if (isset($_FILES['product_images'])) {
    $fileCount = count($_FILES['product_images']['name']);
    
    for ($i = 0; $i < $fileCount; $i++) {
        if ($_FILES['product_images']['error'][$i] === UPLOAD_ERR_OK) {
            $photoTmpName = $_FILES['product_images']['tmp_name'][$i];
            $photoInfo = @getimagesize($photoTmpName);
            $photoError = $_FILES['product_images']['error'][$i];

            if ($photoError === 0 && $photoInfo !== false) {
                // Generate a unique photo name
                $photoName = uniqid() . "." . pathinfo($_FILES["product_images"]["name"][$i], PATHINFO_EXTENSION);
                $imageFormat = strtolower(pathinfo($photoName, PATHINFO_EXTENSION));
                $photoDestination = 'uploads/' . $photoName;

                // Resize the image if it's larger than 200KB
                if ($_FILES['product_images']['size'][$i] > 200000) {
                    $sourceImage = null;
                    list($originalWidth, $originalHeight) = $photoInfo;

                    switch ($imageFormat) {
                        case 'jpeg':
                        case 'jpg':
                            $sourceImage = imagecreatefromjpeg($photoTmpName);
                            break;
                        case 'png':
                            $sourceImage = imagecreatefrompng($photoTmpName);
                            break;
                        case 'gif':
                            $sourceImage = imagecreatefromgif($photoTmpName);
                            break;
                        case 'webp':
                            $sourceImage = imagecreatefromwebp($photoTmpName);
                            break;
                        default:
                            $error_message = "Unsupported image format.";
                            break;
                    }

                    if ($sourceImage) {
                        // Calculate the new dimensions while maintaining the aspect ratio
                        $scaleFactor = sqrt(200000 / $_FILES['product_images']['size'][$i]);
                        $newWidth = intval($originalWidth * $scaleFactor);
                        $newHeight = intval($originalHeight * $scaleFactor);

                        // Resize the image
                        $resizedImage = imagescale($sourceImage, $newWidth, $newHeight);

                        // Load watermark (logo) and apply it
                        $watermark = imagecreatefrompng('../logo.png');
                        $watermarkWidth = imagesx($watermark);
                        $watermarkHeight = imagesy($watermark);
                        $watermarkX = 10;
                        $watermarkY = 50;
                        imagecopy($resizedImage, $watermark, $watermarkX, $watermarkY, 0, 0, $watermarkWidth, $watermarkHeight);

                        // Save the resized image with the watermark
                        switch ($imageFormat) {
                            case 'jpeg':
                            case 'jpg':
                                imagejpeg($resizedImage, $photoDestination, 75); // Quality 75 to reduce size
                                break;
                            case 'png':
                                imagepng($resizedImage, $photoDestination);
                                break;
                            case 'gif':
                                imagegif($resizedImage, $photoDestination);
                                break;
                            case 'webp':
                                imagewebp($resizedImage, $photoDestination);
                                break;
                        }

                        // Free up memory
                        imagedestroy($sourceImage);
                        imagedestroy($resizedImage);
                        imagedestroy($watermark);
                    } else {
                        $error_message = "Error processing the image or unsupported image format.";
                    }
                } else {
                    // No resizing needed, just move the uploaded file
                    move_uploaded_file($photoTmpName, $photoDestination);
                }

                // Insert the image path into the database
                $stmt = $conn->prepare('INSERT INTO product_images (product_id, image_path) VALUES (?, ?)');
                $stmt->bind_param("is", $product_id, $photoDestination);
                $stmt->execute();
            } else {
                $error_message = "Error uploading the photo.";
            }
        }
    }
}



        echo "Product posted successfully.";
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Post Product</title>
    <script>
        // Function to get the user's current location
        function getLocation() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(showPosition);
            } else {
                alert("Geolocation is not supported by this browser.");
            }
        }

        // Function to update the input fields with latitude and longitude values
        function showPosition(position) {
            document.getElementById("latitude").value = position.coords.latitude;
            document.getElementById("longitude").value = position.coords.longitude;
        }

        // Function to fetch subcategories based on category selection
        function fetchSubcategories(categoryId) {
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "fetch_subcategories.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

            xhr.onreadystatechange = function () {
                if (this.readyState === 4 && this.status === 200) {
                    document.getElementById('subcategory').innerHTML = this.responseText;
                }
            };

            xhr.send("category_id=" + categoryId);
        }
        
        
        
         // Fetch zones when a state is selected
            $('#Subcategories').on('change', function () {
                var categoryId = $(this).val();
                if (categoryId) {
                    $.ajax({
                        url: 'Subcategories.php',
                        method: 'POST',
                        data: { category_id: categoryId },
                        success: function (response) {
                            $('#subcategory').html(response);
                        }
                    });
                } else {
                    $('#subcategory').html('<option value="">Select Subcategory</option>');
                }
            });

        function toggleTailoringFields() {
            var categorySelect = document.getElementById('category');
            var sizeField = document.getElementById('sizeField');
            var colorField = document.getElementById('colorField');
            
            fetchSubcategories(categorySelect.value);

            if (categorySelect.value == "tailoring") {
                sizeField.style.display = 'block';
                colorField.style.display = 'block';
            } else {
                sizeField.style.display = 'none';
                colorField.style.display = 'none';
            }
        }

        function addImageInput() {
            var imageContainer = document.getElementById('imageContainer');
            var totalImages = imageContainer.querySelectorAll('input[type="file"]').length;

            if (totalImages < 5) {
                var input = document.createElement('input');
                input.type = 'file';
                input.name = 'product_images[]';
                input.className = 'product-image-input';
                imageContainer.appendChild(input);
            }

            if (totalImages + 1 >= 5) {
                document.getElementById('addImageButton').style.display = 'none';
            }

            toggleRemoveButton();
        }

        function removeImageInput() {
            var imageContainer = document.getElementById('imageContainer');
            var inputs = imageContainer.querySelectorAll('input[type="file"]');
            if (inputs.length > 1) {
                imageContainer.removeChild(inputs[inputs.length - 1]);
            }

            if (inputs.length <= 5) {
                document.getElementById('addImageButton').style.display = 'inline';
            }

            toggleRemoveButton();
        }

        function toggleRemoveButton() {
            var imageContainer = document.getElementById('imageContainer');
            var totalImages = imageContainer.querySelectorAll('input[type="file"]').length;

            if (totalImages > 1) {
                document.getElementById('removeImageButton').style.display = 'inline';
            } else {
                document.getElementById('removeImageButton').style.display = 'none';
            }
        }

        window.onload = function () {
            getLocation();
        };
    </script>
</head>
<body>

    <form method="POST" action="post.php" enctype="multipart/form-data">
        <label for="category">Category:</label>
         <select id="category" name="category_id" onchange="toggleTailoringFields();" required>
            <option value="">Select Category</option>
            <?php
            // Dynamically populate categories
            while ($row = mysqli_fetch_assoc($categories)) {
                echo '<option value="' . $row['id'] . '">' . $row['category_name'] . '</option>';
            }
            ?>
        </select><br>

        <label for="subcategory">Subcategory:</label>
        <select id="subcategory" name="subcategory_id" required>
            <option value="">Select Subcategory</option>
        </select><br>

        <label for="product_name">Product Name:</label>
        <input type="text" name="product_name" placeholder="Product Name" required><br>

        <label for="old_price">Old Price:</label>
        <input type="number" step="0.01" name="old_price" placeholder="Old Price" required><br>

        <label for="current_price">Current Price:</label>
        <input type="number" step="0.01" name="current_price" placeholder="Current Price" required><br>

        <label for="quantity">Quantity:</label>
        <input type="number" name="quantity" placeholder="Quantity" required><br>

        <label for="mode">Mode:</label>
        <select name="mode" required>
            <option value="">Select Mode</option>
            <option value="old">Old</option>
            <option value="new">New</option>
        </select><br>

        <input type="hidden" name="latitude" id="latitude" required readonly>
        <input type="hidden" name="longitude" id="longitude" required readonly>

        <div id="sizeField" style="display: none;">
            <label for="size">Size:</label>
            <input type="text" name="size" placeholder="Size"><br>
        </div>

        <div id="colorField" style="display: none;">
            <label for="color">Color:</label>
            <input type="text" name="color" placeholder="Color"><br>
        </div>

        <div id="imageContainer">
            <label for="product_images[]">Product Images (1-5):</label><br>
           
            
            <input type="file" name="product_images[]" multiple>

            
        </div>
        <button type="button" id="addImageButton" onclick="addImageInput()">Add Image</button>
        <button type="button" id="removeImageButton" style="display:none;" onclick="removeImageInput()">Remove Image</button><br><br>

        <button type="submit">Post Product</button>
    </form>
<script>window.onload = function () {
    getLocation();
};

// Function to get the user's current location
function getLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(showPosition, showError);
    } else {
        alert("Geolocation is not supported by this browser.");
    }
}

// Function to update the input fields with latitude and longitude values
function showPosition(position) {
    document.getElementById("latitude").value = position.coords.latitude;
    document.getElementById("longitude").value = position.coords.longitude;
}

function showError(error) {
    switch (error.code) {
        case error.PERMISSION_DENIED:
            alert("User denied the request for Geolocation.");
            break;
        case error.POSITION_UNAVAILABLE:
            alert("Location information is unavailable.");
            break;
        case error.TIMEOUT:
            alert("The request to get user location timed out.");
            break;
        case error.UNKNOWN_ERROR:
            alert("An unknown error occurred.");
            break;
    }
}

// Form submission handler to ensure latitude and longitude are filled in
document.querySelector("form").addEventListener("submit", function (event) {
    if (!document.getElementById("latitude").value || !document.getElementById("longitude").value) {
        event.preventDefault();
        alert("Unable to retrieve your location. Please allow location access and try again.");
        getLocation();
    }
});
</script>
</body>
</html>
